/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.jboss.jndipolicy.plugins;

import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.KnownInterfaces;

public class JavaEE6JndiBindingPolicy
implements DefaultJndiBindingPolicy {
    private static final long serialVersionUID = 1L;

    protected String getBaseJndiName(EjbDeploymentSummary summary) {
        String appName = summary.getAppName();
        String modulePath = summary.getDeploymentPath();
        String moduleName = summary.getDeploymentName();
        String beanName = summary.getBeanMD().getEjbName();
        return (appName != null ? appName + "/" : "") + (modulePath != null ? modulePath + "/" : "") + moduleName + "/" + beanName;
    }

    @Override
    public String getDefaultLocalHomeJndiName(EjbDeploymentSummary summary) {
        return this.getBaseJndiName(summary) + "!" + "localHome";
    }

    @Override
    public String getDefaultLocalJndiName(EjbDeploymentSummary summary) {
        return this.getBaseJndiName(summary) + "!" + "local";
    }

    @Override
    public String getDefaultRemoteHomeJndiName(EjbDeploymentSummary summary) {
        return this.getBaseJndiName(summary) + "!" + "home";
    }

    @Override
    public String getDefaultRemoteJndiName(EjbDeploymentSummary summary) {
        return this.getBaseJndiName(summary) + "!" + "remote";
    }

    @Override
    public String getJndiName(EjbDeploymentSummary summary) {
        return this.getBaseJndiName(summary);
    }

    @Override
    public String getJndiName(EjbDeploymentSummary summary, String iface, KnownInterfaces.KnownInterfaceType ifaceType) {
        String jndiName = null;
        if (KnownInterfaces.isKnownInterface(iface)) {
            iface = null;
        }
        String baseJndiName = this.getBaseJndiName(summary);
        if (ifaceType == KnownInterfaces.KnownInterfaceType.UNKNOWN) {
            jndiName = iface == null ? baseJndiName : baseJndiName + "!" + iface;
        } else {
            boolean is3x = summary.getBeanMD().getJBossMetaData().isEJB3x();
            if (is3x) {
                switch (ifaceType) {
                    case BUSINESS_LOCAL: {
                        if (iface == null) {
                            jndiName = baseJndiName + "!" + ifaceType.toSuffix();
                            break;
                        }
                        jndiName = baseJndiName + "!" + iface;
                        break;
                    }
                    case BUSINESS_REMOTE: 
                    case UNKNOWN: {
                        String setMappedName;
                        JBossEnterpriseBeanMetaData md = summary.getBeanMD();
                        String mappedName = null;
                        if (md.isSession()) {
                            mappedName = ((JBossSessionBeanMetaData)md).getJndiName();
                        }
                        if ((setMappedName = md.getMappedName()) != null && setMappedName.trim().length() > 0) {
                            mappedName = md.getMappedName();
                        }
                        if (mappedName != null && iface == null) {
                            jndiName = mappedName;
                            break;
                        }
                        if (iface == null) {
                            jndiName = baseJndiName + "!" + ifaceType.toSuffix();
                            break;
                        }
                        jndiName = baseJndiName + "!" + iface;
                        break;
                    }
                    case LOCAL_HOME: {
                        jndiName = baseJndiName + "!" + ifaceType.toSuffix();
                        break;
                    }
                    case REMOTE_HOME: {
                        JBossSessionBeanMetaData smd;
                        String explicitHomeJndiName;
                        JBossEnterpriseBeanMetaData beanMd = summary.getBeanMD();
                        if (beanMd.isSession() && (explicitHomeJndiName = (smd = (JBossSessionBeanMetaData)beanMd).getHomeJndiName()) != null && explicitHomeJndiName.length() > 0) {
                            jndiName = explicitHomeJndiName;
                            break;
                        }
                        jndiName = baseJndiName + "!" + ifaceType.toSuffix();
                        break;
                    }
                    case NO_INTERFACE: {
                        jndiName = baseJndiName + "!" + ifaceType.toSuffix();
                    }
                }
            } else {
                switch (ifaceType) {
                    case BUSINESS_LOCAL: 
                    case LOCAL_HOME: {
                        jndiName = summary.getBeanMD().getLocalJndiName();
                        if (jndiName != null && jndiName.trim().length() > 0) {
                            return jndiName;
                        }
                        String ejbName = summary.getBeanMD().getEjbName();
                        jndiName = "local/" + ejbName + '@' + System.identityHashCode(ejbName);
                        break;
                    }
                    case BUSINESS_REMOTE: 
                    case REMOTE_HOME: {
                        JBossEnterpriseBeanMetaData md = summary.getBeanMD();
                        String mappedName = md.getMappedName();
                        if (mappedName == null || mappedName.length() == 0) {
                            if (md.isSession()) {
                                mappedName = ((JBossSessionBeanMetaData)md).getJndiName();
                            } else if (md.isEntity()) {
                                mappedName = ((JBossEntityBeanMetaData)md).getJndiName();
                            }
                        }
                        if ((jndiName = mappedName) != null && jndiName.trim().length() > 0) {
                            return jndiName;
                        }
                        jndiName = baseJndiName;
                    }
                }
            }
        }
        return jndiName;
    }
}

