/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import javax.ejb.EJBLocalObject;
import javax.ejb.Local;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.creator.ejb.EjbClassThreadLocal;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.lang.ClassHelper;

public class LocalProcessor
extends AbstractFinderUser
implements Processor<SessionBeanMetaData, Class<?>> {
    public LocalProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    protected void addBusinessInterface(SessionBeanMetaData metaData, Class<?> businessInterface) {
        if (EJBLocalObject.class.isAssignableFrom(businessInterface)) {
            throw new IllegalStateException("EJB 3.0 Core Specification Violation (4.6.6): The session bean\u2019s business interface " + businessInterface + " must not extend the javax.ejb.EJBLocalObject interface.");
        }
        if (metaData.getBusinessLocals() == null) {
            metaData.setBusinessLocals(new BusinessLocalsMetaData());
        }
        metaData.getBusinessLocals().add(businessInterface.getName());
    }

    public void process(SessionBeanMetaData metaData, Class<?> type) {
        Local local = (Local)this.finder.getAnnotation(type, Local.class);
        if (local == null) {
            return;
        }
        Class<?> beanClass = EjbClassThreadLocal.ejbClass.get();
        if (type.isInterface()) {
            if (beanClass != null && this.isDirectlyImplementedInterface(beanClass, type)) {
                this.addBusinessInterface(metaData, type);
            }
        } else if (type.getName().equals(metaData.getEjbClass())) {
            if (local.value() == null || local.value().length == 0) {
                Class businessInterface = ClassHelper.getDefaultInterface(type);
                this.addBusinessInterface(metaData, businessInterface);
            } else {
                for (Class businessInterface : local.value()) {
                    this.addBusinessInterface(metaData, businessInterface);
                }
            }
        }
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(Local.class);
    }

    private boolean isDirectlyImplementedInterface(Class<?> beanClass, Class<?> intf) {
        Class<?>[] directlyImplementedInterfaces;
        if (!intf.isInterface()) {
            throw new IllegalArgumentException(intf + " is not an interface");
        }
        for (Class<?> directlyImplementedInterface : directlyImplementedInterfaces = beanClass.getInterfaces()) {
            if (!intf.isAssignableFrom(directlyImplementedInterface)) continue;
            return true;
        }
        return false;
    }
}

