/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class OidNameUtil {
    private static final Oid KERBEROS_V5;
    private static final Oid KERBEROS_V5_LEGACY;
    private static final Oid NTLM;
    private static final Oid SPNEGO;

    public static String getName(Oid oid) {
        if (KERBEROS_V5.equals(oid)) {
            return "Kerberos V5";
        }
        if (KERBEROS_V5_LEGACY.equals(oid)) {
            return "Kerberos V5 Legacy";
        }
        if (NTLM.equals(oid)) {
            return "NTLM";
        }
        if (SPNEGO.equals(oid)) {
            return "SPNEGO";
        }
        return String.valueOf(oid);
    }

    static {
        try {
            KERBEROS_V5 = new Oid("1.2.840.113554.1.2.2");
            KERBEROS_V5_LEGACY = new Oid("1.2.840.48018.1.2.2");
            SPNEGO = new Oid("1.3.6.1.5.5.2");
            NTLM = new Oid("1.3.6.1.4.1.311.2.2.10");
        }
        catch (GSSException e) {
            throw new RuntimeException("Unable to initialise Oid", e);
        }
    }
}

