/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.plugins.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.classloading.plugins.visitor.AbstractResourceContext;
import org.jboss.vfs.VirtualFile;

public class VFSResourceContext
extends AbstractResourceContext {
    private VirtualFile file;
    private VirtualFile root;

    public VFSResourceContext(VirtualFile file, String resourceName, ClassLoader classLoader) {
        super(resourceName, classLoader);
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.file = file;
    }

    public URL getUrl() {
        try {
            return this.file.toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.file.openStream();
    }

    public URL getRootUrl() {
        try {
            return this.root.toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void setRoot(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        this.root = root;
    }
}

