/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.attribute;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.security.util.MBeanServerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MappingProvidersDecodeAction
implements PrivilegedExceptionAction<Object> {
    private static final RuntimePermission decodePermission = new RuntimePermission("org.jboss.security.auth.spi.DecodeAction.decode");
    String password;
    ObjectName serviceName;

    MappingProvidersDecodeAction(String password, ObjectName serviceName) {
        this.password = password;
        this.serviceName = serviceName;
    }

    @Override
    public Object run() throws Exception {
        byte[] secret = this.decode64(this.password);
        String secretPassword = new String(secret, "UTF-8");
        return secretPassword.toCharArray();
    }

    private byte[] decode64(String secret) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(decodePermission);
        }
        MBeanServer server = MBeanServerLocator.locateJBoss();
        return (byte[])server.invoke(this.serviceName, "decode64", new Object[]{secret}, new String[]{String.class.getName()});
    }

    static char[] decode(String password, ObjectName serviceName) throws Exception {
        MappingProvidersDecodeAction action = new MappingProvidersDecodeAction(password, serviceName);
        try {
            char[] decode = (char[])AccessController.doPrivileged(action);
            return decode;
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }
}

