/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.HashMap;
import java.util.Iterator;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.parser.ModuleOptionParser;
import org.jboss.security.config.parser.StaxParserUtil;

public class AuthenticationJASPIConfigParser {
    public JASPIAuthenticationInfo parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        JASPIAuthenticationInfo authInfo = new JASPIAuthenticationInfo();
        LoginModuleStackHolder lmsh = null;
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.peek();
            StartElement peekedStartElement = (StartElement)xmlEvent;
            String peekedStartElementName = StaxParserUtil.getStartElementName(peekedStartElement);
            if ("login-module-stack".equals(peekedStartElementName)) {
                StartElement lmshEvent = (StartElement)xmlEventReader.nextEvent();
                Attribute nameAttribute = lmshEvent.getAttributes().next();
                String nameAttributeValue = StaxParserUtil.getAttributeValue(nameAttribute);
                lmsh = new LoginModuleStackHolder(nameAttributeValue, null);
                authInfo.add(lmsh);
                while ("login-module".equals(peekedStartElementName = StaxParserUtil.getStartElementName(peekedStartElement = (StartElement)(xmlEvent = xmlEventReader.peek())))) {
                    lmsh.addAppConfigurationEntry(this.getJAASEntry(xmlEventReader));
                }
                continue;
            }
            if (!"auth-module".equals(peekedStartElementName)) break;
            AuthModuleEntry entry = this.getJaspiEntry(xmlEventReader);
            if (lmsh != null) {
                entry.setLoginModuleStackHolder(lmsh);
            }
            authInfo.add(entry);
        }
        return authInfo;
    }

    private AppConfigurationEntry getJAASEntry(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        StartElement loginModuleElement = (StartElement)xmlEvent;
        Iterator<Attribute> attrs = loginModuleElement.getAttributes();
        while (attrs.hasNext()) {
            Attribute attribute = attrs.next();
            QName attQName = attribute.getName();
            String attributeValue = StaxParserUtil.getAttributeValue(attribute);
            if ("code".equals(attQName.getLocalPart())) {
                codeName = attributeValue;
                continue;
            }
            if (!"flag".equals(attQName.getLocalPart())) continue;
            controlFlag = this.getControlFlag(attributeValue);
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(xmlEventReader));
        return new AppConfigurationEntry(codeName, controlFlag, options);
    }

    private AuthModuleEntry getJaspiEntry(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        ControlFlag flag = ControlFlag.REQUIRED;
        StartElement authModuleElement = (StartElement)xmlEvent;
        Iterator<Attribute> attrs = authModuleElement.getAttributes();
        while (attrs.hasNext()) {
            Attribute attribute = attrs.next();
            QName attQName = attribute.getName();
            String attributeValue = StaxParserUtil.getAttributeValue(attribute);
            if ("code".equals(attQName.getLocalPart())) {
                codeName = attributeValue;
                continue;
            }
            if (!"flag".equals(attQName.getLocalPart())) continue;
            flag = ControlFlag.valueOf((String)attributeValue);
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(xmlEventReader));
        AuthModuleEntry entry = new AuthModuleEntry(codeName, options, null);
        entry.setControlFlag(flag);
        return entry;
    }

    private AppConfigurationEntry.LoginModuleControlFlag getControlFlag(String flag) {
        if ("required".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if ("sufficient".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if ("optional".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        if ("requisite".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        throw new RuntimeException(flag + " is not recognized");
    }
}

