/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.TModelBag;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.request.FindService;
import org.apache.juddi.datatype.response.ServiceInfo;
import org.apache.juddi.datatype.response.ServiceInfos;
import org.apache.juddi.datatype.response.ServiceList;
import org.apache.juddi.error.NameTooLongException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.TooManyOptionsException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class FindServiceFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$FindServiceFunction == null ? (class$org$apache$juddi$function$FindServiceFunction = FindServiceFunction.class$("org.apache.juddi.function.FindServiceFunction")) : class$org$apache$juddi$function$FindServiceFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$FindServiceFunction;

    public FindServiceFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        int i;
        int vectorSize;
        Vector keyedRefVector;
        FindService request = (FindService)regObject;
        String generic = request.getGeneric();
        String businessKey = request.getBusinessKey();
        Vector nameVector = request.getNameVector();
        CategoryBag categoryBag = request.getCategoryBag();
        TModelBag tModelBag = request.getTModelBag();
        FindQualifiers qualifiers = request.getFindQualifiers();
        int maxRows = request.getMaxRows();
        if (!(businessKey != null && businessKey.length() != 0 || nameVector != null && nameVector.size() != 0 || categoryBag != null && categoryBag.size() != 0 || tModelBag != null && tModelBag.size() != 0)) {
            ServiceList list = new ServiceList();
            list.setServiceInfos(new ServiceInfos());
            list.setGeneric(generic);
            list.setOperator(Config.getOperator());
            list.setTruncated(false);
            return list;
        }
        if (categoryBag != null && (keyedRefVector = categoryBag.getKeyedReferenceVector()) != null && (vectorSize = keyedRefVector.size()) > 0) {
            for (i = 0; i < vectorSize; ++i) {
                KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(i);
                String key = keyedRef.getTModelKey();
                if (key != null && key.trim().length() != 0) continue;
                keyedRef.setTModelKey("UUID:A035A07C-F362-44dd-8F95-E2B134BF43B4");
            }
        }
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            Vector qVector;
            dataStore.beginTrans();
            if (nameVector != null) {
                int maxNames = Config.getMaxNameElementsAllowed();
                if (nameVector != null && nameVector.size() > maxNames) {
                    throw new TooManyOptionsException("find_service: names=" + nameVector.size() + ", " + "maxNames=" + maxNames);
                }
                int maxNameLength = Config.getMaxNameLengthAllowed();
                for (int i2 = 0; i2 < nameVector.size(); ++i2) {
                    String name = ((Name)nameVector.elementAt(i2)).getValue();
                    if (name.length() <= maxNameLength) continue;
                    throw new NameTooLongException("find_service: name=" + name + ", " + "length=" + name.length() + ", " + "maxNameLength=" + maxNameLength);
                }
            }
            if (qualifiers != null && (qVector = qualifiers.getFindQualifierVector()) != null && qVector.size() > 0) {
                for (i = 0; i < qVector.size(); ++i) {
                    FindQualifier qualifier = (FindQualifier)qVector.elementAt(i);
                    String qValue = qualifier.getValue();
                    if (qValue.equals("exactNameMatch") || qValue.equals("caseSensitiveMatch") || qValue.equals("orAllKeys") || qValue.equals("orLikeKeys") || qValue.equals("andAllKeys") || qValue.equals("sortByNameAsc") || qValue.equals("sortByNameDesc") || qValue.equals("sortByDateAsc") || qValue.equals("sortByDateDesc") || qValue.equals("serviceSubset") || qValue.equals("combineCategoryBags")) continue;
                    throw new UnsupportedException("find_service: findQualifier=" + qValue);
                }
            }
            Vector<ServiceInfo> infoVector = null;
            boolean truncatedResults = false;
            Vector keyVector = dataStore.findService(businessKey, nameVector, categoryBag, tModelBag, qualifiers);
            if (keyVector != null && keyVector.size() > 0) {
                int rowCount = keyVector.size();
                if (maxRows > 0 && maxRows < rowCount) {
                    rowCount = maxRows;
                    truncatedResults = true;
                }
                infoVector = new Vector<ServiceInfo>(rowCount);
                for (int i3 = 0; i3 < rowCount; ++i3) {
                    infoVector.addElement(dataStore.fetchServiceInfo((String)keyVector.elementAt(i3)));
                }
            }
            dataStore.commit();
            ServiceInfos infos = new ServiceInfos();
            infos.setServiceInfoVector(infoVector);
            ServiceList list = new ServiceList();
            list.setGeneric(generic);
            list.setServiceInfos(infos);
            list.setOperator(Config.getOperator());
            list.setTruncated(truncatedResults);
            ServiceList serviceList = list;
            return serviceList;
        }
        catch (TooManyOptionsException tmoex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)tmoex.getMessage());
            throw tmoex;
        }
        catch (NameTooLongException ntlex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)ntlex.getMessage());
            throw ntlex;
        }
        catch (UnsupportedException suppex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)suppex.getMessage());
            throw suppex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        try {
            TModelBag bag = new TModelBag();
            bag.addTModelKey("uuid:4C2A8920-BE0C-11D7-8920-8DA7324351E5");
            FindService request = new FindService();
            request.setGeneric("2.0");
            request.setTModelBag(bag);
            ServiceList response = (ServiceList)new FindServiceFunction(reg).execute(request);
            System.out.println(response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            reg.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

