/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.cryptor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.cryptor.Cryptor;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.Loader;

public abstract class CryptorFactory {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$cryptor$CryptorFactory == null ? (class$org$apache$juddi$cryptor$CryptorFactory = CryptorFactory.class$("org.apache.juddi.cryptor.CryptorFactory")) : class$org$apache$juddi$cryptor$CryptorFactory));
    private static final String IMPL_KEY = "juddi.cryptor";
    private static final String DEFAULT_IMPL = "org.apache.juddi.cryptor.DefaultCryptor";
    private static Cryptor cryptor = null;
    static /* synthetic */ Class class$org$apache$juddi$cryptor$CryptorFactory;

    public static Cryptor getCryptor() {
        if (cryptor == null) {
            cryptor = CryptorFactory.createCryptor();
        }
        return cryptor;
    }

    private static synchronized Cryptor createCryptor() {
        if (cryptor != null) {
            return cryptor;
        }
        String className = Config.getStringProperty(IMPL_KEY, DEFAULT_IMPL);
        log.debug((Object)("Cryptor Implementation = " + className));
        Class cryptorClass = null;
        try {
            cryptorClass = Loader.getClassForName(className);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("The specified Cryptor class '" + className + "' was not found in classpath."));
            log.error((Object)e);
        }
        try {
            cryptor = (Cryptor)cryptorClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Exception while attempting to instantiate the implementation of Cryptor: " + cryptorClass.getName() + "\n" + e.getMessage()));
            log.error((Object)e);
        }
        return cryptor;
    }

    public static void main(String[] args) throws Exception {
        Cryptor cryptor = CryptorFactory.getCryptor();
        String encryptedText = cryptor.encrypt("password");
        System.out.println("EnCrypted text [" + encryptedText + "]");
        String decryptedText = cryptor.decrypt(encryptedText);
        System.out.println("DeCrypted text " + decryptedText);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

