/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.transport;

import java.util.List;
import javax.wsdl.Port;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.extensions.soap.SoapAddress;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.stack.cxf.transport.AddressRewritingEndpointInfo;

public class SoapTransportFactoryExt
extends SoapTransportFactory {
    private ServerConfig serverConfig;

    public EndpointInfo createEndpointInfo(ServiceInfo serviceInfo, BindingInfo b, Port port) {
        String transportURI = "http://schemas.xmlsoap.org/wsdl/soap/";
        if (b instanceof SoapBindingInfo) {
            SoapBindingInfo sbi = (SoapBindingInfo)b;
            transportURI = sbi.getTransportURI();
        }
        ServerConfig config = this.getServerConfig();
        AddressRewritingEndpointInfo info = new AddressRewritingEndpointInfo(serviceInfo, transportURI, config);
        if (port != null) {
            List ees = port.getExtensibilityElements();
            for (Object extensor : ees) {
                if (SOAPBindingUtil.isSOAPAddress(extensor)) {
                    SoapAddress sa = SOAPBindingUtil.getSoapAddress(extensor);
                    info.addExtensor(sa);
                    info.setAddress(sa.getLocationURI());
                    continue;
                }
                info.addExtensor(extensor);
            }
        }
        return info;
    }

    private ServerConfig getServerConfig() {
        if (this.serverConfig == null) {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            this.serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
        }
        return this.serverConfig;
    }
}

