/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.binding;

import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.jaxws.binding.MessageBinding;
import org.jboss.ws.core.jaxws.binding.PayloadBinding;
import org.jboss.ws.metadata.umdm.EndpointMetaData;

public class BindingProviderImpl
extends CommonBindingProvider
implements BindingProvider {
    private Map<String, Object> requestContext = new HashMap<String, Object>();
    private Map<String, Object> responseContext = new HashMap<String, Object>();

    public BindingProviderImpl(EndpointMetaData epMetaData) {
        super(epMetaData);
    }

    public BindingProviderImpl(String bindingId) {
        super(bindingId, EndpointMetaData.Type.JAXWS);
    }

    @Override
    protected void initBinding(String bindingId, EndpointMetaData.Type type) {
        super.initBinding(bindingId, type);
        if (!"http://www.w3.org/2004/08/wsdl/http".equals(bindingId)) {
            Service.Mode serviceMode;
            Service.Mode mode = serviceMode = this.epMetaData != null ? this.epMetaData.getServiceMode() : null;
            if (serviceMode == Service.Mode.MESSAGE) {
                this.binding = new MessageBinding();
            } else if (serviceMode == Service.Mode.PAYLOAD) {
                this.binding = new PayloadBinding();
            }
        }
        if (this.binding == null) {
            throw new WebServiceException("Unsupported binding: " + bindingId);
        }
    }

    public Map<String, Object> getRequestContext() {
        return this.requestContext;
    }

    public Map<String, Object> getResponseContext() {
        return this.responseContext;
    }

    public Binding getBinding() {
        return (Binding)this.binding;
    }
}

