/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.jws.WebParam;
import javax.jws.WebResult;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.URIParserUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(AnnotationUtil.class);

    private AnnotationUtil() {
    }

    public static <T extends Annotation> T getPrivClassAnnotation(final Class<?> clazz, final Class<T> anoClass) {
        return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return clazz.getAnnotation(anoClass);
            }
        }));
    }

    public static <T extends Annotation> T getPrivMethodAnnotation(final Method method, final Class<T> anoClass) {
        return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return method.getAnnotation(anoClass);
            }
        }));
    }

    public static Annotation[][] getPrivParameterAnnotations(final Method method) {
        return AccessController.doPrivileged(new PrivilegedAction<Annotation[][]>(){

            @Override
            public Annotation[][] run() {
                return method.getParameterAnnotations();
            }
        });
    }

    public static synchronized URLClassLoader getClassLoader(ClassLoader parent) {
        URL[] urls = URIParserUtil.pathToURLs(AnnotationUtil.getClassPath());
        return new URLClassLoader(urls, parent);
    }

    public static synchronized Class loadClass(String className, ClassLoader parent) {
        Class<?> clazz = null;
        URL[] urls = URIParserUtil.pathToURLs(AnnotationUtil.getClassPath());
        URLClassLoader classLoader = new URLClassLoader(urls, parent);
        try {
            clazz = classLoader.loadClass(className);
        }
        catch (Exception e) {
            Message msg = new Message("FAIL_TO_LOAD_CLASS", LOG, new Object[]{className});
            throw new ToolException(msg, (Throwable)e);
        }
        return clazz;
    }

    private static String getClassPath() {
        ClassLoader loader = AnnotationUtil.class.getClassLoader();
        StringBuilder classpath = new StringBuilder(System.getProperty("java.class.path"));
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlloader = (URLClassLoader)loader;
            for (URL url : urlloader.getURLs()) {
                classpath.append(File.pathSeparatorChar);
                classpath.append(url.getFile());
            }
        }
        return classpath.toString();
    }

    public static WebParam getWebParam(Method method, String paraName) {
        Annotation[][] anno = AnnotationUtil.getPrivParameterAnnotations(method);
        int count = method.getParameterTypes().length;
        for (int i = 0; i < count; ++i) {
            for (Annotation ann : anno[i]) {
                WebParam webParam;
                if (ann.annotationType() != WebParam.class || !paraName.equals((webParam = (WebParam)ann).name())) continue;
                return webParam;
            }
        }
        return null;
    }

    public static WebResult getWebResult(Method method) {
        WebResult ann = method.getAnnotation(WebResult.class);
        if (ann == null) {
            return null;
        }
        return ann;
    }
}

