/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.annotation.creator.EjbProcessorUtils;
import org.jboss.metadata.annotation.creator.ejb.InterceptorMetaDataCreator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokeMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.EjbJar30MetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
import org.jboss.metadata.ejb.spec.InterceptorClassesMetaData;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.ejb.spec.InterceptorOrderMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.scanning.annotations.spi.AnnotationIndex;
import org.jboss.scanning.annotations.spi.Element;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.metadata.WeldAwareMetadataDeployer;
import org.jboss.weld.integration.ejb.SessionBeanInterceptor;
import org.jboss.weld.integration.ejb.interceptor.Jsr299BindingsInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldEjbInterceptorMetadataDeployer
extends WeldAwareMetadataDeployer<JBossMetaData> {
    private static final Class<SessionBeanInterceptor> INJECTION_INTERCEPTOR_CLASS = SessionBeanInterceptor.class;
    private static final Class<org.jboss.weld.ejb.SessionBeanInterceptor> CONTEXT_INTERCEPTOR_CLASS = org.jboss.weld.ejb.SessionBeanInterceptor.class;
    private static final Class<Jsr299BindingsInterceptor> BINDINGS_INTERCEPTOR_CLASS = Jsr299BindingsInterceptor.class;
    public static final String INJECTION_INTERCEPTOR_CLASS_NAME = INJECTION_INTERCEPTOR_CLASS.getName();
    public static final String CONTEXT_INTERCEPTOR_CLASS_NAME = CONTEXT_INTERCEPTOR_CLASS.getName();
    public static final String BINDINGS_INTERCEPTOR_CLASS_NAME = BINDINGS_INTERCEPTOR_CLASS.getName();
    private InterceptorMetaData injectionIMD;
    private InterceptorMetaData bindingsIMD;
    private InterceptorMetaData contextIMD;
    private InterceptorBindingMetaData injectionIBMD;
    private InterceptorBindingMetaData contextIBMD;
    private InterceptorMetaDataCreator interceptorMetaDataCreator = new InterceptorMetaDataCreator((AnnotationFinder)new DefaultAnnotationFinder());

    public WeldEjbInterceptorMetadataDeployer() {
        super(JBossMetaData.class, true);
        this.addInput("merged." + JBossMetaData.class.getName());
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        InterceptorsMetaData interceptorsMetaData = this.interceptorMetaDataCreator.create(Arrays.asList(INJECTION_INTERCEPTOR_CLASS, CONTEXT_INTERCEPTOR_CLASS, BINDINGS_INTERCEPTOR_CLASS));
        this.injectionIMD = (InterceptorMetaData)interceptorsMetaData.get(INJECTION_INTERCEPTOR_CLASS_NAME);
        this.contextIMD = (InterceptorMetaData)interceptorsMetaData.get(CONTEXT_INTERCEPTOR_CLASS_NAME);
        if (this.contextIMD.getAroundInvokes() == null) {
            this.contextIMD.setAroundInvokes(new AroundInvokesMetaData());
        }
        AroundInvokeMetaData aroundInvokeMetaData = new AroundInvokeMetaData();
        aroundInvokeMetaData.setClassName(CONTEXT_INTERCEPTOR_CLASS_NAME);
        aroundInvokeMetaData.setMethodName("aroundInvoke");
        this.contextIMD.getAroundInvokes().add((Object)aroundInvokeMetaData);
        this.bindingsIMD = (InterceptorMetaData)interceptorsMetaData.get(BINDINGS_INTERCEPTOR_CLASS_NAME);
        this.injectionIBMD = this.createInterceptorBindingMetadata(INJECTION_INTERCEPTOR_CLASS_NAME);
        this.contextIBMD = this.createInterceptorBindingMetadata(CONTEXT_INTERCEPTOR_CLASS_NAME);
    }

    private InterceptorBindingMetaData createInterceptorBindingMetadata(String interceptorClassName) {
        InterceptorBindingMetaData ibmd = new InterceptorBindingMetaData();
        InterceptorClassesMetaData interceptorClasses = new InterceptorClassesMetaData();
        interceptorClasses.add((Object)interceptorClassName);
        ibmd.setInterceptorClasses(interceptorClasses);
        ibmd.setEjbName("*");
        return ibmd;
    }

    @Override
    protected void internalDeploy(VFSDeploymentUnit unit, JBossMetaData jbmd, Collection<VirtualFile> wbXml) throws DeploymentException {
        InterceptorBindingsMetaData interceptorBindings;
        if (jbmd.getInterceptors() == null) {
            InterceptorsMetaData imd = new InterceptorsMetaData();
            EjbJar30MetaData ejmd = new EjbJar30MetaData();
            ejmd.setInterceptors(imd);
            jbmd.merge(null, (EjbJarMetaData)ejmd);
        }
        InterceptorsMetaData interceptors = jbmd.getInterceptors();
        interceptors.add((MappableMetaData)this.injectionIMD);
        interceptors.add((MappableMetaData)this.bindingsIMD);
        interceptors.add((MappableMetaData)this.contextIMD);
        JBossAssemblyDescriptorMetaData assemblyDescriptor = jbmd.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            assemblyDescriptor = new JBossAssemblyDescriptorMetaData();
            jbmd.setAssemblyDescriptor(assemblyDescriptor);
        }
        if ((interceptorBindings = assemblyDescriptor.getInterceptorBindings()) == null) {
            interceptorBindings = new InterceptorBindingsMetaData();
            assemblyDescriptor.setInterceptorBindings(interceptorBindings);
        }
        if (jbmd.isEJB3x() && jbmd.getEnterpriseBeans() != null) {
            this.processEjbInterceptorMetadata(jbmd.getEnterpriseBeans(), interceptorBindings, (DeploymentUnit)unit);
        }
        for (InterceptorBindingMetaData interceptorBinding : interceptorBindings) {
            if (interceptorBinding.getInterceptorOrder() == null || interceptorBinding.getInterceptorOrder().isEmpty()) continue;
            if (!INJECTION_INTERCEPTOR_CLASS_NAME.equals(interceptorBinding.getInterceptorOrder().iterator().next())) {
                this.log.warn((Object)("The Web Beans SessionnBeanInterceptor is not the inner most EJB interceptor in this deployment. JSR299 injection may not work correctly. Specify " + INJECTION_INTERCEPTOR_CLASS_NAME + " as the first interceptor in the interceptor ordering for " + interceptorBinding.getEjbName()));
            }
            Iterator iterator = interceptorBinding.getInterceptorOrder().iterator();
            do {
                Object lastInterceptorClassName = iterator.next();
            } while (iterator.hasNext());
        }
    }

    private InterceptorBindingMetaData createBinding(String className, String ejbName, NamedMethodMetaData method, boolean excludeClassInterceptors) {
        InterceptorClassesMetaData interceptorClasses = new InterceptorClassesMetaData();
        interceptorClasses.add((Object)className);
        return this.createBinding(interceptorClasses, null, ejbName, method);
    }

    private InterceptorBindingMetaData createBinding(InterceptorClassesMetaData classesMetaData, InterceptorOrderMetaData orderMetaData, String ejbName, NamedMethodMetaData method) {
        InterceptorBindingMetaData ibmd = new InterceptorBindingMetaData();
        ibmd.setInterceptorClasses(classesMetaData);
        ibmd.setEjbName(ejbName);
        if (orderMetaData != null) {
            ibmd.setInterceptorOrder(orderMetaData);
        }
        if (method != null) {
            ibmd.setMethod(method);
        }
        return ibmd;
    }

    private void processEjbInterceptorMetadata(JBossEnterpriseBeansMetaData jBossEnterpriseBeansMetaData, InterceptorBindingsMetaData interceptorBindings, DeploymentUnit deploymentUnit) {
        ArrayList<InterceptorBindingMetaData> classInterceptorBindings = new ArrayList<InterceptorBindingMetaData>();
        ArrayList<InterceptorBindingMetaData> methodInterceptorBindings = new ArrayList<InterceptorBindingMetaData>();
        for (InterceptorBindingMetaData interceptorBinding : interceptorBindings) {
            if (!"*".equals(interceptorBinding.getEjbName()) && null != interceptorBinding.getEjbName() && !interceptorBinding.getEjbName().trim().equals("") && interceptorBinding.getMethod() == null) {
                classInterceptorBindings.add(interceptorBinding);
            }
            if (null == interceptorBinding.getMethod()) continue;
            methodInterceptorBindings.add(interceptorBinding);
        }
        HashSet<NamedMethodMetaData> processedMethodMetadatas = new HashSet<NamedMethodMetaData>();
        if (!this.excludeClassLevelInterceptorsExist(deploymentUnit) && methodInterceptorBindings.isEmpty() && classInterceptorBindings.isEmpty() && this.getMethodsWithExcludedClasses(deploymentUnit).isEmpty() && this.getMethodsWithExcludedDefaults(deploymentUnit).isEmpty()) {
            interceptorBindings.add(0, (Object)this.createBinding(INJECTION_INTERCEPTOR_CLASS_NAME, "*", null, false));
            interceptorBindings.add(0, (Object)this.createBinding(CONTEXT_INTERCEPTOR_CLASS_NAME, "*", null, false));
            interceptorBindings.add((Object)this.createBinding(BINDINGS_INTERCEPTOR_CLASS_NAME, "*", null, false));
        } else {
            for (JBossEnterpriseBeanMetaData jBossEnterpriseBeanMetaData : jBossEnterpriseBeansMetaData) {
                String ejbName = jBossEnterpriseBeanMetaData.getEjbName();
                interceptorBindings.add(0, (Object)this.createBinding(INJECTION_INTERCEPTOR_CLASS_NAME, ejbName, null, false));
                interceptorBindings.add(0, (Object)this.createBinding(CONTEXT_INTERCEPTOR_CLASS_NAME, ejbName, null, false));
                interceptorBindings.add((Object)this.createBinding(BINDINGS_INTERCEPTOR_CLASS_NAME, ejbName, null, false));
            }
            if (!methodInterceptorBindings.isEmpty()) {
                for (InterceptorBindingMetaData interceptorBindingMetaData : methodInterceptorBindings) {
                    if (!interceptorBindingMetaData.isExcludeClassInterceptors()) {
                        ArrayList<InterceptorBindingMetaData> replacementInterceptorBindings = new ArrayList<InterceptorBindingMetaData>();
                        for (InterceptorBindingMetaData classInterceptorBinding : classInterceptorBindings) {
                            if (!interceptorBindingMetaData.getEjbName().equals(classInterceptorBinding.getEjbName())) continue;
                            replacementInterceptorBindings.add(0, this.createBinding(classInterceptorBinding.getInterceptorClasses(), classInterceptorBinding.getInterceptorOrder(), interceptorBindingMetaData.getEjbName(), interceptorBindingMetaData.getMethod()));
                        }
                        interceptorBindings.addAll(0, replacementInterceptorBindings);
                    }
                    interceptorBindings.add((Object)this.createBinding(BINDINGS_INTERCEPTOR_CLASS_NAME, interceptorBindingMetaData.getEjbName(), interceptorBindingMetaData.getMethod(), interceptorBindingMetaData.isExcludeClassInterceptors()));
                    processedMethodMetadatas.add(interceptorBindingMetaData.getMethod());
                    interceptorBindingMetaData.setExcludeClassInterceptors(true);
                }
            }
            for (Element element : this.getMethodsWithExcludedClasses(deploymentUnit)) {
                for (JBossEnterpriseBeanMetaData enterpriseBeanMetaData : jBossEnterpriseBeansMetaData) {
                    if (!enterpriseBeanMetaData.getEjbClass().equals(element.getOwnerClassName())) continue;
                    String ejbName = enterpriseBeanMetaData.getEjbName();
                    NamedMethodMetaData namedMethod = new NamedMethodMetaData();
                    namedMethod.setMethodName(((Method)element.getAnnotatedElement()).getName());
                    MethodParametersMetaData methodParams = EjbProcessorUtils.getMethodParameters((Method)((Method)element.getAnnotatedElement()));
                    namedMethod.setMethodParams(methodParams);
                    if (processedMethodMetadatas.contains(namedMethod)) continue;
                    interceptorBindings.add(0, (Object)this.createBinding(INJECTION_INTERCEPTOR_CLASS_NAME, ejbName, namedMethod, false));
                    interceptorBindings.add(0, (Object)this.createBinding(CONTEXT_INTERCEPTOR_CLASS_NAME, ejbName, namedMethod, false));
                    interceptorBindings.add((Object)this.createBinding(BINDINGS_INTERCEPTOR_CLASS_NAME, ejbName, namedMethod, false));
                    processedMethodMetadatas.add(namedMethod);
                }
            }
        }
    }

    private boolean excludeClassLevelInterceptorsExist(DeploymentUnit unit) {
        AnnotationIndex annotationRepository = (AnnotationIndex)unit.getAttachment(AnnotationIndex.class);
        if (annotationRepository != null) {
            return !annotationRepository.classIsAnnotatedWith(ExcludeDefaultInterceptors.class).isEmpty();
        }
        return true;
    }

    private Set<Element<ExcludeDefaultInterceptors, Method>> getMethodsWithExcludedDefaults(DeploymentUnit unit) {
        AnnotationIndex annotationRepository = (AnnotationIndex)unit.getAttachment(AnnotationIndex.class);
        if (annotationRepository != null) {
            return annotationRepository.classHasMethodAnnotatedWith(ExcludeDefaultInterceptors.class);
        }
        return Collections.emptySet();
    }

    private Set<Element<ExcludeClassInterceptors, Method>> getMethodsWithExcludedClasses(DeploymentUnit unit) {
        AnnotationIndex annotationRepository = (AnnotationIndex)unit.getAttachment(AnnotationIndex.class);
        if (annotationRepository != null) {
            return annotationRepository.classHasMethodAnnotatedWith(ExcludeClassInterceptors.class);
        }
        return Collections.emptySet();
    }
}

