/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.classloader.plugins.loader.ClassLoaderToLoaderAdapter;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.base.BaseClassLoaderSource;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.logging.Logger;
import org.jboss.weld.integration.deployer.env.bda.Archive;
import org.jboss.weld.integration.deployer.env.bda.ArchiveInfo;
import org.jboss.weld.integration.deployer.env.bda.Classpath;
import org.jboss.weld.integration.deployer.env.bda.ClasspathImpl;
import org.jboss.weld.integration.deployer.env.bda.LibraryArchivesProvider;
import org.jboss.weld.integration.deployer.env.bda.NoDuplicatesClasspath;
import org.jboss.weld.integration.deployer.env.bda.SecurityActions;

class ClasspathFactory {
    private static Logger log = Logger.getLogger(ClasspathFactory.class);
    private static final ClasspathFactory instance = new ClasspathFactory();
    private volatile ClassLoaderSystem system;
    private volatile ClassLoaderDomain defaultDomain;
    private volatile Classpath defaultClasspath;
    private LibraryArchivesProvider libArchivesProvider;
    private final Map<Loader, WeakReference<Classpath>> domainToClasspath = new WeakHashMap<Loader, WeakReference<Classpath>>();

    public static final ClasspathFactory getInstance() {
        return instance;
    }

    private ClasspathFactory() {
    }

    protected ClassLoaderSystem getSystem() {
        if (this.system == null) {
            this.setSystem(ClassLoaderSystem.getInstance());
        }
        return this.system;
    }

    public void setSystem(ClassLoaderSystem system) {
        if (system == null) {
            throw new IllegalArgumentException("Null system");
        }
        this.system = system;
        this.defaultDomain = system.getDefaultDomain();
        this.defaultClasspath = new ClasspathImpl(this.defaultDomain.getName(), new Archive[0]);
    }

    public void setLibArchivesProvider(LibraryArchivesProvider libArchivesProvider) {
        this.libArchivesProvider = libArchivesProvider;
    }

    public void create() throws Exception {
        if (this.libArchivesProvider != null) {
            this.libArchivesProvider.getLibraries();
        }
    }

    public Classpath create(ClassLoader classLoader) {
        Module module = SecurityActions.getModuleForClassLoader(classLoader);
        ClassLoaderDomain domain = null;
        ClassLoaderSystem cls = this.getSystem();
        if (module != null && module.getDeterminedParentDomainName() != null) {
            domain = cls.getDomain(module.getDeterminedDomainName());
        }
        return this.getClasspath((Loader)domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Classpath getClasspath(Loader domain) {
        if (domain == null || domain == this.defaultDomain) {
            return this.defaultClasspath;
        }
        Loader loader = domain;
        synchronized (loader) {
            Classpath classpath = this.getCachedClasspath(domain);
            if (classpath == null) {
                if (domain instanceof ClassLoaderToLoaderAdapter) {
                    ArchiveInfo archiveInfo;
                    ClassLoaderToLoaderAdapter cl2la = (ClassLoaderToLoaderAdapter)domain;
                    ClassLoader unitLoader = SecurityActions.getClassLoader((BaseClassLoaderSource)cl2la);
                    ArchiveInfo archiveInfo2 = archiveInfo = unitLoader == null ? null : ArchiveInfo.getInstance(unitLoader);
                    classpath = archiveInfo == null ? new NoDuplicatesClasspath(domain.toString(), new Archive[0]) : archiveInfo.getClasspathAdapter();
                } else if (domain instanceof ClassLoaderDomain) {
                    ClassLoaderDomain clDomain = (ClassLoaderDomain)domain;
                    Classpath parentClasspath = this.getClasspath(clDomain.getParent());
                    classpath = new NoDuplicatesClasspath(clDomain.getName(), parentClasspath, new Archive[0]);
                } else {
                    throw new RuntimeException("Domain is of unexpected type: " + domain + " - " + domain.getClass());
                }
                this.addClasspathToCache(domain, classpath);
            }
            return classpath;
        }
    }

    private Classpath getCachedClasspath(Loader domain) {
        WeakReference<Classpath> ref = this.domainToClasspath.get(domain);
        if (ref == null) {
            return null;
        }
        return (Classpath)ref.get();
    }

    private void addClasspathToCache(Loader domain, Classpath domainClasspath) {
        this.domainToClasspath.put(domain, new WeakReference<Classpath>(domainClasspath));
    }
}

