/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.proxy.Proxy;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.MergeMetaDataInterceptor;
import org.jboss.aspects.remoting.Remoting;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.transport.Connector;
import org.jboss.util.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotingProxyFactory {
    private static final Logger log = Logger.getLogger(RemotingProxyFactory.class);
    private Object target;
    private Class<?>[] interfaces;
    private String dispatchName;
    private String jndiName;
    private InvokerLocator invokerLocator;
    private Connector connector;
    private String subsystem = "AOP";
    private ArrayList<?> interceptors;
    private ArrayList<Interceptor> verifiedInterceptors;
    private Proxy proxy;

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Class<?>[] getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(Class<?>[] interfaces) {
        this.interfaces = interfaces;
        for (int i = 0; i < interfaces.length; ++i) {
            log.debug((Object)("interface[" + i + "]: " + interfaces[i]));
        }
    }

    public String getDispatchName() {
        return this.dispatchName;
    }

    public void setDispatchName(String dispatchName) {
        this.dispatchName = dispatchName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getInvokerLocator() {
        return this.invokerLocator.toString();
    }

    public void setInvokerLocator(String locator) throws MalformedURLException {
        this.invokerLocator = new InvokerLocator(locator);
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    public ArrayList<?> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(ArrayList<?> interceptors) {
        this.interceptors = interceptors;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void start() throws Exception {
        this.doSanityChecks();
        this.verifyInterceptors();
        Dispatcher.singleton.registerTarget((Object)this.dispatchName, this.target);
        ClassLoader loader = this.getContextClassLoader();
        this.proxy = Remoting.createRemoteProxy(this.dispatchName, loader, this.interfaces, this.invokerLocator, this.verifiedInterceptors, this.subsystem);
        log.debug((Object)("Created proxy for target \"" + this.dispatchName + "\""));
        if (this.jndiName != null) {
            InitialContext ctx = new InitialContext();
            Util.bind((Context)ctx, (String)this.jndiName, (Object)this.proxy);
            log.debug((Object)("Bound proxy for target \"" + this.dispatchName + "\" to \"" + this.jndiName + "\""));
        }
    }

    public void stop() throws Exception {
        Dispatcher.singleton.unregisterTarget((Object)this.dispatchName);
        log.debug((Object)("Unregistered proxy target: \"" + this.dispatchName + "\""));
        if (this.jndiName != null) {
            InitialContext ctx = new InitialContext();
            Util.unbind((Context)ctx, (String)this.jndiName);
            log.debug((Object)("Unbound proxy for target \"" + this.dispatchName + "\" from JNDI: \"" + this.jndiName + "\""));
        }
    }

    private void doSanityChecks() throws Exception {
        if (this.target == null) {
            throw new Exception("Cannot start factory: target == null");
        }
        if (this.interfaces == null) {
            throw new Exception("Cannot start factory: interfaces == null");
        }
        if (this.interfaces.length == 0) {
            throw new Exception("Cannot start factory: interfaces is empty array");
        }
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (this.interfaces[i].isInstance(this.target)) continue;
            throw new Exception("Cannot start factory: " + this.target + " does not implement " + this.interfaces[i]);
        }
        if (this.dispatchName == null) {
            throw new Exception("Cannot start factory: dispatchName == null");
        }
        if (this.invokerLocator == null && this.connector == null) {
            throw new Exception("Cannot start factory: locator == null and connector == null");
        }
        if (this.invokerLocator == null) {
            this.invokerLocator = this.connector.getLocator();
        }
    }

    private void verifyInterceptors() throws Exception {
        this.verifiedInterceptors = new ArrayList(this.interceptors.size());
        Interceptor interceptor = null;
        ClassLoader tcl = this.getContextClassLoader();
        for (Object o : this.interceptors) {
            log.debug((Object)("processing interceptor: " + o));
            if (o instanceof String) {
                Class<?> c = Class.forName((String)o, true, tcl);
                try {
                    Field field = c.getDeclaredField("singleton");
                    interceptor = (Interceptor)field.get(null);
                }
                catch (Exception e) {
                    log.debug((Object)(c.getName() + " has no singleton element: trying default constructor"));
                    interceptor = (Interceptor)c.newInstance();
                }
                if (o == null) {
                    throw new Exception("Cannot start factory: unable to create instance of " + c.getName());
                }
            } else if (o instanceof Interceptor) {
                interceptor = (Interceptor)o;
            } else {
                throw new Exception(o + " is neither String nor Interceptor");
            }
            this.verifiedInterceptors.add(interceptor);
            log.debug((Object)("added interceptor: " + interceptor));
        }
        interceptor = MergeMetaDataInterceptor.singleton;
        this.verifiedInterceptors.add(interceptor);
        log.debug((Object)("added interceptor: " + interceptor));
        interceptor = InvokeRemoteInterceptor.singleton;
        this.verifiedInterceptors.add(interceptor);
        log.debug((Object)("added interceptor: " + interceptor));
    }

    private ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

