/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import org.jboss.mx.metadata.IllegalPropertyException;
import org.jboss.mx.metadata.MetaDataBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuilder
implements MetaDataBuilder {
    protected Map<String, Object> properties = new HashMap<String, Object>();

    public AbstractBuilder() {
    }

    public AbstractBuilder(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean getBooleanProperty(String key) throws IllegalPropertyException {
        Object value = this.properties.get(key);
        if (value == null) {
            throw new IllegalPropertyException("boolean property " + key + " does not exist");
        }
        if (value instanceof String) {
            String v = (String)value;
            if (v.equalsIgnoreCase("true")) {
                return true;
            }
            if (v.equalsIgnoreCase("false")) {
                return false;
            }
            if (v.equalsIgnoreCase("t")) {
                return true;
            }
            if (v.equalsIgnoreCase("f")) {
                return false;
            }
            throw new IllegalPropertyException("unknown string value '" + v + "' for boolean property");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalPropertyException("illegal property type: " + value.getClass().getName());
    }

    public String getStringProperty(String key) {
        return (String)this.properties.get(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public abstract MBeanInfo build() throws NotCompliantMBeanException;

    protected void setProperties(Map<String, Object> properties) {
        this.properties = new HashMap<String, Object>(properties);
    }

    protected Map<String, Object> getProperties() {
        return this.properties;
    }
}

