/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class RspListTest {
    RspList rl;
    Address a1;
    Address a2;
    Address a3;
    Address a4;
    Address a5;
    Rsp rsp1;
    Rsp rsp2;
    Rsp rsp3;
    Rsp rsp4;
    Rsp rsp5;

    @BeforeMethod
    public void setUp() throws Exception {
        this.rl = new RspList();
        this.a1 = Util.createRandomAddress();
        this.a2 = Util.createRandomAddress();
        this.a3 = Util.createRandomAddress();
        this.a4 = Util.createRandomAddress();
        this.a5 = Util.createRandomAddress();
        this.rsp1 = new Rsp(this.a1);
        this.rsp2 = new Rsp(this.a2, true);
        this.rsp3 = new Rsp<String>(this.a3, "hello world");
        this.rsp4 = new Rsp<Boolean>(this.a4, Boolean.TRUE);
        this.rsp5 = new Rsp(this.a5, true);
        this.rl.put(this.a1, this.rsp1);
        this.rl.put(this.a2, this.rsp2);
        this.rl.put(this.a3, this.rsp3);
        this.rl.put(this.a4, this.rsp4);
        this.rl.put(this.a5, this.rsp5);
    }

    @AfterMethod
    protected void tearDown() throws Exception {
        this.rl.clear();
    }

    public void testConstructor() {
        LinkedList<Rsp> c = new LinkedList<Rsp>();
        c.add(this.rsp1);
        c.add(this.rsp2);
        c.add(this.rsp3);
        RspList tmp = new RspList(c);
        Assert.assertEquals((int)c.size(), (int)tmp.size());
        assert (tmp.containsKey(this.a1));
        assert (tmp.containsKey(this.a2));
        assert (tmp.containsKey(this.a3));
        assert (tmp.containsValue(this.rsp1));
        assert (tmp.containsValue(this.rsp2));
        assert (tmp.containsValue(this.rsp3));
    }

    public void testIsEmpty() {
        RspList tmp = new RspList();
        assert (tmp.isEmpty());
        tmp.addRsp(this.a1, this.rsp1);
        assert (!tmp.isEmpty());
    }

    public void testContainsKey() {
        assert (this.rl.containsKey(this.a1));
        assert (this.rl.containsKey(this.a3));
    }

    public void testContainsValue() {
        assert (this.rl.containsValue(this.rsp1));
        assert (this.rl.containsValue(this.rsp3));
    }

    public void testGet() {
        Rsp rsp = this.rl.get(this.a1);
        Assert.assertEquals((Object)rsp, (Object)this.rsp1);
        rsp = this.rl.get(this.a3);
        Assert.assertEquals((Object)rsp, (Object)this.rsp3);
    }

    public void testPut() {
        Rsp rsp = this.rl.put(Util.createRandomAddress(), new Rsp(Util.createRandomAddress(), true));
        assert (rsp == null);
        rsp = this.rl.put(this.a2, this.rsp2);
        Assert.assertEquals((Object)rsp, (Object)this.rsp2);
        Assert.assertEquals((int)6, (int)this.rl.size());
    }

    public void testRemove() {
        Rsp rsp = this.rl.remove(Util.createRandomAddress());
        assert (rsp == null);
        rsp = this.rl.remove(this.a2);
        Assert.assertEquals((Object)rsp, (Object)this.rsp2);
        Assert.assertEquals((int)4, (int)this.rl.size());
    }

    public void testClear() {
        this.rl.clear();
        Assert.assertEquals((int)0, (int)this.rl.size());
    }

    public static void testKeySet() {
        RspList tmp = new RspList();
        Set<Address> keys = tmp.keySet();
        assert (keys != null);
        Assert.assertEquals((int)0, (int)keys.size());
    }

    public void testKeySet2() {
        Set<Address> keys = this.rl.keySet();
        assert (keys != null);
        Assert.assertEquals((int)this.rl.size(), (int)keys.size());
    }

    public void testAddRsp() {
        Address tmp = Util.createRandomAddress();
        this.rl.addRsp(tmp, new Integer(322649));
        Assert.assertEquals((int)6, (int)this.rl.size());
        Rsp rsp = this.rl.get(tmp);
        assert (rsp != null);
        assert (rsp.wasReceived());
        assert (!rsp.wasSuspected());
        Assert.assertEquals((Object)new Integer(322649), rsp.getValue());
    }

    public void testAddRsp2() {
        this.rl.addRsp(this.a1, new Integer(322649));
        Assert.assertEquals((int)5, (int)this.rl.size());
        Rsp rsp = this.rl.get(this.a1);
        assert (rsp != null);
        assert (rsp.wasReceived());
        assert (!rsp.wasSuspected());
        Assert.assertEquals((Object)new Integer(322649), rsp.getValue());
    }

    public void testNumSuspectedMembers() {
        Assert.assertEquals((int)2, (int)this.rl.numSuspectedMembers());
    }

    public void testGetFirst() {
        Object obj = this.rl.getFirst();
        System.out.println("-- first (non-null) value is " + obj);
        assert (obj != null);
    }

    public void testGetResults() {
        Vector<Object> v = this.rl.getResults();
        assert (v != null);
        Assert.assertEquals((int)2, (int)v.size());
    }

    public void testElementAt() {
        HashSet<Address> s = new HashSet<Address>();
        s.addAll(this.rl.keySet());
        System.out.println("-- set is " + s);
        Assert.assertEquals((int)this.rl.size(), (int)s.size());
    }

    public void testElementAtWithOOBEx() {
        try {
            this.rl.elementAt(6);
            assert (false) : "this should have thrown an ArrayIndexOutOfBoundsException";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

