/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.Message;
import org.jgroups.stack.AckSenderWindow;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.DefaultTimeScheduler;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class AckSenderWindowTest {
    static final int NUM_MSGS = 100;
    static final long[] xmit_timeouts = new long[]{1000L, 2000L, 4000L, 8000L};
    static final double PERCENTAGE_OFF = 1.3;
    final Map<Long, Entry> msgs = new ConcurrentHashMap<Long, Entry>();

    @DataProvider(name="provider")
    Object[][] provider() {
        DefaultTimeScheduler timer = new DefaultTimeScheduler(10);
        return new Object[][]{{timer, new AckSenderWindow(new MyRetransmitCommand(), new StaticInterval(xmit_timeouts), timer)}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="provider")
    public void testSimpleAdd(TimeScheduler timer, AckSenderWindow win) throws InterruptedException {
        try {
            for (int i = 1; i <= 5; ++i) {
                win.add(i, new Message());
            }
            System.out.println("win = " + win);
            assert (win.size() == 5);
            win.ack(1L);
            System.out.println("win = " + win);
            assert (win.size() == 4);
            win.ack(4L);
            System.out.println("win = " + win);
            assert (win.size() == 1);
            win.ack(44L);
            assert (win.size() == 0);
        }
        finally {
            timer.stop();
            win.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="provider")
    public void testRetransmits(TimeScheduler timer, AckSenderWindow win) throws InterruptedException {
        int num_non_correct_entries = 0;
        try {
            System.out.println("-- sending 100 messages:");
            for (long i = 0L; i < 100L; ++i) {
                this.msgs.put(new Long(i), new Entry());
                win.add(i, new Message());
            }
            System.out.println("-- done");
            System.out.println("-- waiting for all retransmits");
            long end_time = System.currentTimeMillis() + 20000L;
            long start = System.currentTimeMillis();
            Util.sleep(1000L);
            while (System.currentTimeMillis() < end_time && (num_non_correct_entries = this.checkEntries(false)) != 0) {
                Util.sleep(2000L);
            }
            System.out.println("-- waited for " + (System.currentTimeMillis() - start) + " ms");
            num_non_correct_entries = this.checkEntries(true);
            if (num_non_correct_entries > 0) {
                System.err.println("Number of incorrect retransmission timeouts: " + num_non_correct_entries);
            }
            assert (num_non_correct_entries == 0);
        }
        finally {
            timer.stop();
            win.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="provider")
    public void testLowest(TimeScheduler timer, AckSenderWindow win) {
        try {
            for (long i = 1L; i < 5L; ++i) {
                win.add(i, new Message());
            }
            System.out.println("win = " + win + ", lowest=" + win.getLowest());
            assert (win.getLowest() == 1L);
            win.ack(3L);
            System.out.println("win = " + win + ", lowest=" + win.getLowest());
            assert (win.getLowest() == 4L);
            win.ack(4L);
            System.out.println("win = " + win + ", lowest=" + win.getLowest());
            assert (win.getLowest() == 5L);
            win.ack(2L);
            assert (win.getLowest() == 5L);
        }
        finally {
            timer.stop();
            win.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="provider")
    public void testGetLowestMessage(TimeScheduler timer, AckSenderWindow win) {
        long[] seqnos = new long[]{1L, 2L, 3L, 4L, 5L};
        Message[] messages = new Message[]{new Message(), new Message(), new Message(), new Message(), new Message()};
        try {
            for (int i = 0; i < seqnos.length; ++i) {
                win.add(seqnos[i], messages[i]);
            }
            System.out.println("win = " + win);
            Message msg = win.getLowestMessage();
            assert (messages[0] == msg);
            win.ack(2L);
            msg = win.getLowestMessage();
            assert (messages[2] == msg);
            win.ack(7L);
            msg = win.getLowestMessage();
            assert (msg == null);
        }
        finally {
            timer.stop();
            win.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="provider")
    public void testAdd(TimeScheduler timer, AckSenderWindow win) {
        try {
            for (int i = 1; i <= 10; ++i) {
                win.add(i, new Message());
            }
            System.out.println("win = " + win);
            assert (win.size() == 10);
            win.ack(7L);
            assert (win.size() == 3);
        }
        finally {
            timer.stop();
            win.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="provider")
    public void testAck(TimeScheduler timer, AckSenderWindow win) {
        try {
            for (int i = 1; i <= 3; ++i) {
                win.add(i, new Message());
            }
            assert (win.size() == 3);
            win.ack(1L);
            assert (win.size() == 2);
            win.ack(2L);
            assert (win.size() == 1);
            win.ack(3L);
            assert (win.size() == 0);
        }
        finally {
            timer.stop();
            win.reset();
        }
    }

    private int checkEntries(boolean print) {
        int retval = 0;
        for (long i = 0L; i < 100L; ++i) {
            Entry entry = this.msgs.get(new Long(i));
            if (entry.isCorrect(i, print)) continue;
            ++retval;
        }
        return retval;
    }

    class MyRetransmitCommand
    implements AckSenderWindow.RetransmitCommand {
        MyRetransmitCommand() {
        }

        @Override
        public void retransmit(long seqno, Message msg) {
            Entry entry = AckSenderWindowTest.this.msgs.get(seqno);
            if (entry != null) {
                if (entry.first_xmit == 0L) {
                    entry.first_xmit = System.currentTimeMillis();
                    return;
                }
                if (entry.second_xmit == 0L) {
                    entry.second_xmit = System.currentTimeMillis();
                    return;
                }
                if (entry.third_xmit == 0L) {
                    entry.third_xmit = System.currentTimeMillis();
                    return;
                }
                if (entry.fourth_xmit == 0L) {
                    entry.fourth_xmit = System.currentTimeMillis();
                }
            }
        }
    }

    static class Entry {
        long start_time = System.currentTimeMillis();
        long first_xmit = 0L;
        long second_xmit = 0L;
        long third_xmit = 0L;
        long fourth_xmit = 0L;

        Entry() {
        }

        boolean isCorrect(long seqno, boolean print) {
            long delta;
            long expected = xmit_timeouts[0];
            long t = this.first_xmit - this.start_time;
            long diff = Math.abs(expected - t);
            if (diff <= (delta = (long)((double)expected * 1.3))) {
                return true;
            }
            expected = xmit_timeouts[1];
            t = this.second_xmit - this.first_xmit;
            diff = Math.abs(expected - t);
            if (diff <= (delta = (long)((double)expected * 1.3))) {
                return true;
            }
            expected = xmit_timeouts[2];
            t = this.third_xmit - this.second_xmit;
            diff = Math.abs(expected - t);
            if (diff <= (delta = (long)((double)expected * 1.3))) {
                return true;
            }
            expected = xmit_timeouts[3];
            t = this.fourth_xmit - this.third_xmit;
            diff = Math.abs(expected - t);
            if (diff <= (delta = (long)((double)expected * 1.3))) {
                return true;
            }
            if (print) {
                System.err.println("#" + seqno + ": " + this + ": (" + "entry is more than " + 1.3 + " percentage off ");
                return false;
            }
            return true;
        }

        boolean isCorrect(long seqno) {
            return this.isCorrect(seqno, true);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.first_xmit - this.start_time).append(", ").append(this.second_xmit - this.first_xmit).append(", ");
            sb.append(this.third_xmit - this.second_xmit).append(", ").append(this.fourth_xmit - this.third_xmit);
            return sb.toString();
        }
    }
}

