/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.remoting;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.MergeMetaDataInterceptor;
import org.jboss.aspects.remoting.Remoting;
import org.jboss.aspects.security.SecurityClientInterceptor;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.logging.Logger;
import org.jboss.profileservice.remoting.SecurityContainer;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.remoting.InvokerLocator;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.util.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFactory {
    private static final Logger log = Logger.getLogger(ProxyFactory.class);
    private String dispatchName = "ProfileService";
    private String jndiName = "ProfileService";
    private String localJndiName = "java:ProfileService";
    private String mgtViewJndiName = "java:ManagementView";
    private String deployMgrJndiName = "java:DeploymentManager";
    private InvokerLocator locator;
    private ProfileService ps;
    private ManagementView mgtView;
    private DeploymentManager deployMgr;
    private org.jboss.aop.proxy.Proxy psProxy;
    private org.jboss.aop.proxy.Proxy mgtViewProxy;
    private org.jboss.aop.proxy.Proxy deployMgrProxy;
    private ProfileService psProxySecure;
    private List<Interceptor> serverProxyInterceptors;
    private List<Interceptor> proxyInterceptors;
    private boolean createEjb3Links;

    public String getDispatchName() {
        return this.dispatchName;
    }

    public void setDispatchName(String dispatchName) {
        this.dispatchName = dispatchName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getMgtViewJndiName() {
        return this.mgtViewJndiName;
    }

    public void setMgtViewJndiName(String mgtViewJndiName) {
        this.mgtViewJndiName = mgtViewJndiName;
    }

    public String getDeployMgrJndiName() {
        return this.deployMgrJndiName;
    }

    public void setDeployMgrJndiName(String deployMgrJndiName) {
        this.deployMgrJndiName = deployMgrJndiName;
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public void setLocator(InvokerLocator locator) {
        this.locator = locator;
    }

    public ProfileService getProfileService() {
        return this.ps;
    }

    public void setProfileService(ProfileService ps) {
        this.ps = ps;
    }

    public org.jboss.aop.proxy.Proxy getProfileServiceProxy() {
        return this.psProxy;
    }

    public ManagementView getViewManager() {
        return this.mgtView;
    }

    public void setViewManager(ManagementView mgtView) {
        this.mgtView = mgtView;
    }

    public org.jboss.aop.proxy.Proxy getManagementViewProxy() {
        return this.mgtViewProxy;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deployMgr;
    }

    public void setDeploymentManager(DeploymentManager deployMgr) {
        this.deployMgr = deployMgr;
    }

    public org.jboss.aop.proxy.Proxy getDeployMgrProxy() {
        return this.deployMgrProxy;
    }

    public List<Interceptor> getProxyInterceptors() {
        return this.proxyInterceptors;
    }

    public void setProxyInterceptors(List<Interceptor> proxyInterceptors) {
        this.proxyInterceptors = proxyInterceptors;
    }

    public List<Interceptor> getServerProxyInterceptors() {
        return this.serverProxyInterceptors;
    }

    public void setServerProxyInterceptors(List<Interceptor> serverProxyInterceptors) {
        this.serverProxyInterceptors = serverProxyInterceptors;
    }

    public boolean isCreateEjb3Links() {
        return this.createEjb3Links;
    }

    public void setCreateEjb3Links(boolean createEjb3Links) {
        this.createEjb3Links = createEjb3Links;
    }

    public void start() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class[] ifaces = new Class[]{ProfileService.class};
        if (this.serverProxyInterceptors == null) {
            this.serverProxyInterceptors = new ArrayList<Interceptor>();
        }
        SecurityContainer container = new SecurityContainer(this.serverProxyInterceptors, this.ps);
        this.psProxySecure = (ProfileService)Proxy.newProxyInstance(loader, ifaces, (InvocationHandler)container);
        InitialContext ctx = new InitialContext();
        NonSerializableFactory.rebind((Context)ctx, (String)this.localJndiName, (Object)this.ps);
        Dispatcher.singleton.registerTarget((Object)this.dispatchName, (Object)this.psProxySecure);
        if (this.proxyInterceptors == null) {
            this.proxyInterceptors = new ArrayList<Interceptor>();
            this.proxyInterceptors.add((Interceptor)SecurityClientInterceptor.singleton);
            this.proxyInterceptors.add((Interceptor)MergeMetaDataInterceptor.singleton);
            this.proxyInterceptors.add((Interceptor)InvokeRemoteInterceptor.singleton);
        }
        this.psProxy = Remoting.createRemoteProxy((Object)this.dispatchName, (ClassLoader)loader, (Class[])ifaces, (InvokerLocator)this.locator, this.proxyInterceptors, (String)"ProfileService");
        Util.bind((Context)ctx, (String)this.jndiName, (Object)this.psProxy);
        log.debug((Object)("Bound ProfileService proxy under: " + this.jndiName));
        SecurityContainer container2 = new SecurityContainer(this.serverProxyInterceptors, this.mgtView);
        Class[] ifaces2 = new Class[]{ManagementView.class};
        ManagementView mgtViewSecure = (ManagementView)Proxy.newProxyInstance(loader, ifaces2, (InvocationHandler)container2);
        Class[] mvIfaces = new Class[]{ManagementView.class};
        String mvDispatchName = this.dispatchName + ".ManagementView";
        Dispatcher.singleton.registerTarget((Object)mvDispatchName, (Object)mgtViewSecure);
        this.mgtViewProxy = Remoting.createRemoteProxy((Object)mvDispatchName, (ClassLoader)loader, (Class[])mvIfaces, (InvokerLocator)this.locator, this.proxyInterceptors, (String)"ProfileService");
        log.debug((Object)"Created ManagementView proxy");
        if (this.mgtViewJndiName != null && this.mgtViewJndiName.length() > 0) {
            Util.bind((Context)ctx, (String)this.mgtViewJndiName, (Object)this.mgtViewProxy);
            log.debug((Object)("Bound ManagementView proxy under: " + this.mgtViewJndiName));
        }
        SecurityContainer container3 = new SecurityContainer(this.serverProxyInterceptors, this.deployMgr);
        Class[] ifaces3 = new Class[]{DeploymentManager.class};
        DeploymentManager deployMgrSecure = (DeploymentManager)Proxy.newProxyInstance(loader, ifaces3, (InvocationHandler)container3);
        Class[] dmIfaces = new Class[]{DeploymentManager.class};
        String dmDispatchName = this.dispatchName + ".DeploymentManager";
        Dispatcher.singleton.registerTarget((Object)dmDispatchName, (Object)deployMgrSecure);
        this.deployMgrProxy = Remoting.createRemoteProxy((Object)dmDispatchName, (ClassLoader)loader, (Class[])dmIfaces, (InvokerLocator)this.locator, this.proxyInterceptors, (String)"DeploymentManager");
        log.debug((Object)"Created DeploymentManager proxy");
        if (this.deployMgrJndiName != null && this.deployMgrJndiName.length() > 0) {
            Util.bind((Context)ctx, (String)this.deployMgrJndiName, (Object)this.deployMgrProxy);
            log.debug((Object)("Bound DeploymentManager proxy under: " + this.deployMgrJndiName));
        }
        if (this.createEjb3Links) {
            Util.createLinkRef((String)"SecureProfileService/remote", (String)this.jndiName);
            Util.createLinkRef((String)"SecureManagementView/remote", (String)this.mgtViewJndiName);
            Util.createLinkRef((String)"SecureDeploymentManager/remote", (String)this.deployMgrJndiName);
            log.debug((Object)"Bound links back to secure ejb names");
        }
    }

    public void stop() throws Exception {
        Dispatcher.singleton.unregisterTarget((Object)this.dispatchName);
        String mvDispatchName = this.dispatchName + ".ManagementView";
        Dispatcher.singleton.unregisterTarget((Object)mvDispatchName);
        InitialContext ctx = new InitialContext();
        Util.unbind((Context)ctx, (String)this.jndiName);
        log.debug((Object)"Unbound ProfileService proxy");
        if (this.mgtViewJndiName != null && this.mgtViewJndiName.length() > 0) {
            Util.unbind((Context)ctx, (String)this.mgtViewJndiName);
            log.debug((Object)"Unbound ManagementView proxy");
        }
        if (this.deployMgrJndiName != null && this.deployMgrJndiName.length() > 0) {
            Util.unbind((Context)ctx, (String)this.deployMgrJndiName);
            log.debug((Object)"Unbound DeploymentManager proxy");
        }
        if (this.createEjb3Links) {
            Util.unbind((Context)ctx, (String)"SecureProfileService/remote");
            Util.unbind((Context)ctx, (String)"SecureManagementView/remote");
            Util.unbind((Context)ctx, (String)"SecureDeploymentManager/remote");
            log.debug((Object)"Unbound links back to secure ejb names");
        }
    }
}

