/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.views;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.bootstrap.api.server.Server;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.MutableManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.ManagedComponentImpl;
import org.jboss.managed.plugins.ManagedDeploymentImpl;
import org.jboss.managed.plugins.ManagedOperationImpl;
import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
import org.jboss.metadata.spi.MetaData;
import org.jboss.profileservice.plugins.management.util.ManagedDeploymentProcessor;
import org.jboss.profileservice.plugins.management.view.AbstractProfileView;
import org.jboss.profileservice.plugins.management.view.AbstractProfileViewWrapper;
import org.jboss.profileservice.plugins.spi.ProfileView;
import org.jboss.profileservice.plugins.spi.ProfileViewProcessingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapProfileView
extends AbstractProfileViewWrapper {
    private static final Logger log = Logger.getLogger(BootstrapProfileView.class);
    private static final ManagedObjectFactory managedObjectFactory = ManagedObjectFactoryBuilder.create();
    private final AbstractProfileView view = new AbstractProfileView();
    private final Kernel kernel;
    private Server server;
    private final Map<String, KernelDeployment> deployments;

    public BootstrapProfileView(Kernel kernel, Map<String, KernelDeployment> deployments) {
        this.kernel = kernel;
        this.deployments = deployments;
    }

    protected ProfileView getDelegate() {
        return this.view;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public boolean load() {
        if (this.deployments == null) {
            return false;
        }
        if (this.view.load()) {
            this.processServer();
            for (Map.Entry<String, KernelDeployment> entry : this.deployments.entrySet()) {
                String deploymentName = entry.getKey();
                try {
                    this.processDeployment(deploymentName, entry.getValue());
                }
                catch (Exception e) {
                    log.error((Object)("failed to process managed deployment " + deploymentName));
                }
            }
            return true;
        }
        return false;
    }

    protected void processServer() {
        ComponentType type = new ComponentType("MCBean", "MCServer");
        ManagedObject serverMO = managedObjectFactory.initManagedObject((Object)this.server, "JBossServer", null);
        if (serverMO.getOperations() != null && serverMO.getOperations().size() == 0) {
            ManagedOperationImpl shutdown = new ManagedOperationImpl("Shutdown the server", "shutdown");
            if (serverMO instanceof MutableManagedObject) {
                HashSet<ManagedOperationImpl> ops = new HashSet<ManagedOperationImpl>();
                ops.add(shutdown);
                MutableManagedObject mmo = (MutableManagedObject)MutableManagedObject.class.cast(serverMO);
                mmo.setOperations(ops);
            }
        }
        ManagedComponentImpl serverComp = new ManagedComponentImpl(type, null, serverMO);
        type = new ComponentType("MCBean", "ServerConfig");
        ManagedObject mo = managedObjectFactory.initManagedObject((Object)this.server.getConfiguration(), null);
        ManagedComponentImpl configComp = new ManagedComponentImpl(type, null, mo);
        this.view.addManagedComponent((ManagedComponent)serverComp);
        this.view.addManagedComponent((ManagedComponent)configComp);
    }

    protected void processDeployment(String deploymentName, KernelDeployment deployment) throws Exception {
        ManagedDeploymentProcessor processor = new ManagedDeploymentProcessor(this.getProxyFactory());
        ManagedDeployment md = this.createManagedDeployment(deploymentName, deployment);
        processor.processRootManagedDeployment(md, (ProfileViewProcessingContext)this.view);
    }

    ManagedDeployment createManagedDeployment(String deploymentName, KernelDeployment kernelDeployment) {
        HashMap<String, ManagedObject> managedObjects = new HashMap<String, ManagedObject>();
        List beanFactories = kernelDeployment.getBeanFactories();
        if (beanFactories != null && !beanFactories.isEmpty()) {
            for (BeanMetaDataFactory beanFactory : beanFactories) {
                List beans = beanFactory.getBeans();
                if (beans == null || beans.isEmpty()) continue;
                for (BeanMetaData bmd : beans) {
                    String name = bmd.getName();
                    ControllerContext context = this.getKernelController().getContext((Object)bmd.getName(), null);
                    MetaData metaData = this.getMetaDataRepository().getMetaData(context);
                    ManagedObject mo = managedObjectFactory.initManagedObject((Object)bmd, null, metaData, name, null);
                    if (mo == null) continue;
                    managedObjects.put(name, mo);
                }
            }
        }
        return new ManagedDeploymentImpl(kernelDeployment.getName(), kernelDeployment.getName(), null, managedObjects);
    }

    KernelController getKernelController() {
        return this.kernel.getController();
    }

    KernelMetaDataRepository getMetaDataRepository() {
        return this.kernel.getMetaDataRepository();
    }

    public void removeComponent(ManagedComponent update, ManagedComponent original) throws Exception {
    }

    public void updateComponent(ManagedComponent update, ManagedComponent original) throws Exception {
    }
}

