/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.progresswatch;

public class ProgressWatcher {
    private boolean started = false;
    private int totalWork = -1;
    private int finishedWork = -1;

    public void start() {
        this.totalWork = 0;
        this.finishedWork = 0;
        this.started = true;
    }

    public int getPercentComplete() throws IllegalStateException {
        if (!this.started) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " not started yet. call start() to set progress to 0 and start watching.");
        }
        if (this.totalWork == 0) {
            return 0;
        }
        float percentComp = (float)this.finishedWork / (float)this.totalWork * 100.0f;
        return (int)percentComp;
    }

    public void setTotalWork(int totalWorkIn) {
        this.totalWork = totalWorkIn;
    }

    public void addWork(int workToAdd) {
        this.totalWork += workToAdd;
    }

    public void finishWork(int workToRemove) {
        if (!this.started) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " not started yet. call start() to set progress to 0 and start watching.");
        }
        this.finishedWork += workToRemove;
    }

    public void stop() {
        this.started = false;
    }

    public void resetToZero() {
        this.stop();
        this.start();
    }
}

