/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore.http;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.beanstore.AttributeBeanStore;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.util.collections.EnumerationList;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionBeanStore
extends AttributeBeanStore {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONTEXT);

    protected abstract HttpSession getSession(boolean var1);

    public AbstractSessionBeanStore(NamingScheme namingScheme) {
        super(namingScheme);
    }

    @Override
    protected Collection<String> getAttributeNames() {
        HttpSession session = this.getSession(false);
        if (session == null) {
            return Collections.emptyList();
        }
        return new EnumerationList((Enumeration)Reflections.cast(session.getAttributeNames()));
    }

    @Override
    protected void removeAttribute(String key) {
        HttpSession session = this.getSession(false);
        if (session != null) {
            session.removeAttribute(key);
            log.trace("Removed " + key + " from session " + this.getSession(false).getId());
        } else {
            log.trace("Unable to remove " + key + " from non-existent session");
        }
    }

    @Override
    protected void setAttribute(String key, Object instance) {
        HttpSession session = this.getSession(true);
        if (session != null) {
            session.setAttribute(key, instance);
            log.trace("Added " + key + " to session " + this.getSession(false).getId());
        } else {
            log.trace("Unable to add " + key + " to session as no session could be obtained");
        }
    }

    @Override
    protected Object getAttribute(String prefixedId) {
        return this.getSession(false).getAttribute(prefixedId);
    }
}

