/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.spi;

import java.io.ObjectStreamException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.PackageInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberInfo
extends PrimitiveInfo
implements ClassInfo {
    private static final long serialVersionUID = 1L;
    public static final NumberInfo BYTE_OBJECT = new NumberInfo(0, Byte.class);
    public static final NumberInfo DOUBLE_OBJECT = new NumberInfo(1, Double.class);
    public static final NumberInfo FLOAT_OBJECT = new NumberInfo(2, Float.class);
    public static final NumberInfo INT_OBJECT = new NumberInfo(3, Integer.class);
    public static final NumberInfo LONG_OBJECT = new NumberInfo(4, Long.class);
    public static final NumberInfo SHORT_OBJECT = new NumberInfo(5, Short.class);
    public static final NumberInfo ATOMIC_INT = new NumberInfo(6, AtomicInteger.class);
    public static final NumberInfo ATOMIC_LONG = new NumberInfo(7, AtomicLong.class);
    private static final NumberInfo[] values = new NumberInfo[]{BYTE_OBJECT, DOUBLE_OBJECT, FLOAT_OBJECT, INT_OBJECT, LONG_OBJECT, SHORT_OBJECT, ATOMIC_INT, ATOMIC_LONG};
    private static final HashMap<String, NumberInfo> map = new HashMap();
    private transient ClassInfo delegate;
    private transient Phase phase = Phase.INSTANTIATED;

    public static NumberInfo valueOf(String name) {
        return map.get(name);
    }

    protected NumberInfo(int ordinal, Class<? extends Object> type) {
        super(type.getName(), ordinal, type);
    }

    public void setDelegate(TypeInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Null info");
        }
        if (!(info instanceof ClassInfo)) {
            throw new IllegalArgumentException("Should be of ClassInfo instance: " + info.getClass().getName());
        }
        if (info instanceof NumberInfo) {
            throw new IllegalArgumentException("Cannot be delegate to itself: " + info);
        }
        this.delegate = (ClassInfo)info;
        this.phase = Phase.COMPLETE;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public void initializing() {
        this.phase = Phase.INITIALIZING;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberInfo)) {
            return false;
        }
        NumberInfo other = (NumberInfo)obj;
        return other.ordinal == this.ordinal;
    }

    @Override
    Object readResolve() throws ObjectStreamException {
        return values[this.ordinal];
    }

    @Override
    public ConstructorInfo getDeclaredConstructor(TypeInfo ... parameters) {
        return this.delegate.getDeclaredConstructor(parameters);
    }

    @Override
    public ConstructorInfo[] getDeclaredConstructors() {
        return this.delegate.getDeclaredConstructors();
    }

    @Override
    public FieldInfo getDeclaredField(String fieldName) {
        return this.delegate.getDeclaredField(fieldName);
    }

    @Override
    public FieldInfo[] getDeclaredFields() {
        return this.delegate.getDeclaredFields();
    }

    @Override
    public MethodInfo getDeclaredMethod(String methodName, TypeInfo ... parameters) {
        return this.delegate.getDeclaredMethod(methodName, parameters);
    }

    @Override
    public MethodInfo[] getDeclaredMethods() {
        return this.delegate.getDeclaredMethods();
    }

    @Override
    public InterfaceInfo[] getGenericInterfaces() {
        return this.delegate.getGenericInterfaces();
    }

    @Override
    public ClassInfo getGenericSuperclass() {
        return this.delegate.getGenericSuperclass();
    }

    @Override
    public InterfaceInfo[] getInterfaces() {
        return this.delegate.getInterfaces();
    }

    @Override
    public ClassInfo getSuperclass() {
        return this.delegate.getSuperclass();
    }

    @Override
    public boolean isInterface() {
        return this.delegate.isInterface();
    }

    @Override
    public AnnotationValue getAnnotation(String annotationName) {
        return this.delegate.getAnnotation(annotationName);
    }

    @Override
    public AnnotationValue[] getAnnotations() {
        return this.delegate.getAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(String annotationName) {
        return this.delegate.isAnnotationPresent(annotationName);
    }

    @Override
    public <T extends Annotation> T getUnderlyingAnnotation(Class<T> annotationType) {
        return this.delegate.getUnderlyingAnnotation(annotationType);
    }

    @Override
    public Annotation[] getUnderlyingAnnotations() {
        return this.delegate.getUnderlyingAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.delegate.isAnnotationPresent(annotationType);
    }

    @Override
    public int getModifiers() {
        return this.delegate.getModifiers();
    }

    @Override
    public boolean isPublic() {
        return this.delegate.isPublic();
    }

    @Override
    public boolean isStatic() {
        return this.delegate.isStatic();
    }

    @Override
    public boolean isVolatile() {
        return this.delegate.isVolatile();
    }

    @Override
    public boolean isPrimitive() {
        return this.delegate.isPrimitive();
    }

    @Override
    public TypeInfo[] getActualTypeArguments() {
        return this.delegate.getActualTypeArguments();
    }

    @Override
    public TypeInfo getOwnerType() {
        return this.delegate.getOwnerType();
    }

    @Override
    public ClassInfo getRawType() {
        return this.delegate;
    }

    @Override
    public TypeInfo getComponentType() {
        return this.delegate.getComponentType();
    }

    @Override
    public TypeInfo getKeyType() {
        return this.delegate.getKeyType();
    }

    @Override
    public TypeInfo getValueType() {
        return this.delegate.getValueType();
    }

    @Override
    public PackageInfo getPackage() {
        return this.delegate.getPackage();
    }

    public Object clone() {
        return this;
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }

    @Override
    public String getTypeVariable() {
        return null;
    }

    static {
        map.put(Byte.class.getName(), BYTE_OBJECT);
        map.put(Double.class.getName(), DOUBLE_OBJECT);
        map.put(Float.class.getName(), FLOAT_OBJECT);
        map.put(Integer.class.getName(), INT_OBJECT);
        map.put(Long.class.getName(), LONG_OBJECT);
        map.put(Short.class.getName(), SHORT_OBJECT);
        map.put(AtomicInteger.class.getName(), ATOMIC_INT);
        map.put(AtomicLong.class.getName(), ATOMIC_LONG);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Phase {
        INSTANTIATED,
        INITIALIZING,
        COMPLETE;

    }
}

