/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist.bytecode;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import javassist.CtClass;
import javassist.bytecode.ClassFileWriter;
import javassist.bytecode.Descriptor;
import javassist.bytecode.Opcode;
import org.jboss.reflect.plugins.javassist.bytecode.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassFileWriterContext<T> {
    private static final Method defineClass1;
    private static final Method defineClass2;
    final Class<T> type;
    final String name;
    final ClassFileWriter fileWriter;
    final ClassFileWriter.ConstPoolWriter poolWriter;
    final int thisClass;
    final int superClass;
    final int[] interfaces;
    final ClassFileWriter.MethodWriter mw;
    byte[] bytes;
    int stackDepth;
    int maxStackDepth;

    ClassFileWriterContext(String name, String superClassName, Class<T> type, String[] interfaceNames) {
        this.name = name;
        this.type = type;
        name = ClassFileWriterContext.jvmClassName(name);
        superClassName = ClassFileWriterContext.jvmClassName(superClassName);
        for (int i = 0; i < interfaceNames.length; ++i) {
            interfaceNames[i] = ClassFileWriterContext.jvmClassName(interfaceNames[i]);
        }
        this.fileWriter = new ClassFileWriter(48, 0);
        this.poolWriter = this.fileWriter.getConstPool();
        this.thisClass = this.poolWriter.addClassInfo(name);
        this.superClass = this.poolWriter.addClassInfo(superClassName);
        this.interfaces = this.poolWriter.addClassInfo(interfaceNames);
        this.mw = this.fileWriter.getMethodWriter();
        this.mw.begin(1, "<init>", "()V", null, null);
        this.mw.add(42);
        this.mw.add(183);
        int signature = this.poolWriter.addNameAndTypeInfo("<init>", "()V");
        this.mw.add16(this.poolWriter.addMethodrefInfo(this.superClass, signature));
        this.mw.add(177);
        this.mw.codeEnd(1, 1);
        this.mw.end(null, null);
    }

    String getSimpleType() {
        return this.type.getSimpleName();
    }

    String getName() {
        return this.name;
    }

    void beginMethod(int accessFlags, String name, String descriptor, String[] exceptions) {
        this.mw.begin(1, name, descriptor, exceptions, null);
    }

    void endMethod(int maxLocals) {
        this.mw.codeEnd(this.maxStackDepth, maxLocals);
        this.mw.end(null, null);
    }

    void addInvokeStatic(String targetClass, String methodName, String descriptor) {
        this.mw.addInvoke(184, targetClass, methodName, descriptor);
        this.growStack(Descriptor.dataSize((String)descriptor));
    }

    void addInvokeVirtual(String targetClass, String methodName, String descriptor) {
        this.mw.addInvoke(182, targetClass, methodName, descriptor);
        this.growStack(Descriptor.dataSize((String)descriptor) - 1);
    }

    void addInvokeInterface(String targetClass, String methodName, String descriptor, int count) {
        this.mw.addInvoke(185, targetClass, methodName, descriptor);
        this.mw.add(count);
        this.mw.add(0);
        this.growStack(Descriptor.dataSize((String)descriptor) - 1);
    }

    void addInvokeSpecial(String targetClass, String methodName, String descriptor) {
        this.mw.addInvoke(183, targetClass, methodName, descriptor);
        this.growStack(Descriptor.dataSize((String)descriptor) - 1);
    }

    void addGetField(String className, String fieldName, String type) {
        this.mw.add(180);
        this.addFieldRefInfo(className, fieldName, type);
        this.growStack(Descriptor.dataSize((String)type) - 1);
    }

    void addGetStatic(String className, String fieldName, String type) {
        this.mw.add(178);
        this.addFieldRefInfo(className, fieldName, type);
        this.growStack(Descriptor.dataSize((String)type));
    }

    void addPutField(String className, String fieldName, String type) {
        this.mw.add(181);
        this.addFieldRefInfo(className, fieldName, type);
        this.growStack(1 - Descriptor.dataSize((String)type));
    }

    void addPutStatic(String className, String fieldName, String type) {
        this.mw.add(179);
        this.addFieldRefInfo(className, fieldName, type);
        this.growStack(-Descriptor.dataSize((String)type));
    }

    void addAReturn() {
        this.mw.add(176);
        this.growStack(-1);
    }

    void addAConstNull() {
        this.mw.add(1);
        this.growStack(1);
    }

    void addAALoad() {
        this.mw.add(50);
        this.growStack(-1);
    }

    void addAload(int i) {
        if (i < 4) {
            this.mw.add(42 + i);
        } else if (i < 256) {
            this.mw.add(25);
            this.mw.add(i);
        } else {
            this.mw.add(196);
            this.mw.add(25);
            this.addIndex(i);
        }
        this.growStack(1);
    }

    void addIconst(int i) {
        if (i < 6 && -2 < i) {
            this.mw.add(3 + i);
        } else if (i <= 127 && -128 <= i) {
            this.mw.add(16);
            this.mw.add(i);
        } else if (i <= Short.MAX_VALUE && Short.MIN_VALUE <= i) {
            this.mw.add(17);
            this.mw.add(i >> 8);
            this.mw.add(i);
        } else {
            int ref = this.poolWriter.addIntegerInfo(i);
            if (i > 255) {
                this.mw.add(19);
                this.mw.add(i >> 8);
                this.mw.add(i);
            } else {
                this.mw.add(18);
                this.mw.add(ref);
            }
        }
        this.growStack(1);
    }

    void addNew(String className) {
        this.mw.add(187);
        this.addIndex(this.addClassInfo(className));
        this.growStack(1);
    }

    void addDup() {
        this.mw.add(89);
        this.growStack(1);
    }

    void addCheckcast(String clazz) {
        this.mw.add(192);
        int i = this.poolWriter.addClassInfo(clazz);
        this.addIndex(i);
    }

    byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = this.fileWriter.end(1, this.thisClass, this.superClass, this.interfaces, null);
        }
        return this.bytes;
    }

    Class<T> toClass(ClassLoader loader, ProtectionDomain domain) throws InvocationTargetException, IllegalAccessException {
        byte[] bytes = this.getBytes();
        if (domain == null) {
            return (Class)SecurityActions.invoke(defineClass1, loader, this.name, bytes, 0, bytes.length);
        }
        return (Class)SecurityActions.invoke(defineClass2, loader, this.name, bytes, 0, bytes.length, domain);
    }

    private void addIndex(int i) {
        this.mw.add(i >> 8);
        this.mw.add(i);
    }

    private void addFieldRefInfo(String className, String fieldName, String type) {
        this.addIndex(this.poolWriter.addFieldrefInfo(this.poolWriter.addClassInfo(className), this.poolWriter.addNameAndTypeInfo(fieldName, type)));
    }

    private int addClassInfo(String className) {
        return this.poolWriter.addClassInfo(className.replace('.', '/'));
    }

    private void growStack(int i) {
        this.stackDepth += i;
        if (this.stackDepth > this.maxStackDepth) {
            this.maxStackDepth = this.stackDepth;
        }
    }

    static String jvmClassName(CtClass clazz) {
        return ClassFileWriterContext.jvmClassName(clazz.getName());
    }

    static String jvmClassName(String name) {
        return name.replace('.', '/');
    }

    public static void main(String[] args) {
        System.out.println("  Opcode.INVOKESTATIC   \t" + Opcode.STACK_GROW[184]);
        System.out.println("  Opcode.INVOKEVIRTUAL  \t" + Opcode.STACK_GROW[182]);
        System.out.println("  Opcode.INVOKEINTERFACE\t" + Opcode.STACK_GROW[185]);
        System.out.println("  Opcode.INVOKESPECIAL  \t" + Opcode.STACK_GROW[183]);
        System.out.println("  Opcode.GETFIELD       \t" + Opcode.STACK_GROW[180]);
        System.out.println("  Opcode.GETSTATIC      \t" + Opcode.STACK_GROW[178]);
        System.out.println("  Opcode.PUTFIELD       \t" + Opcode.STACK_GROW[181]);
        System.out.println("  Opcode.PUTSTATIC      \t" + Opcode.STACK_GROW[179]);
        System.out.println("  Opcode.ARETURN        \t" + Opcode.STACK_GROW[176]);
        System.out.println("  Opcode.ACONST_NULL    \t" + Opcode.STACK_GROW[1]);
        System.out.println("  Opcode.AALOAD         \t" + Opcode.STACK_GROW[50]);
        System.out.println("  Opcode.ALOAD_1        \t" + Opcode.STACK_GROW[43]);
        System.out.println("  Opcode.ALOAD          \t" + Opcode.STACK_GROW[25]);
        System.out.println("  Opcode.WIDE           \t" + Opcode.STACK_GROW[196]);
        System.out.println("  Opcode.NEW            \t" + Opcode.STACK_GROW[187]);
        System.out.println("  Opcode.DUP            \t" + Opcode.STACK_GROW[89]);
        System.out.println("  Opcode.CHECKCAST      \t" + Opcode.STACK_GROW[192]);
        System.out.println("  Opcode.ICONST_1)      \t" + Opcode.STACK_GROW[4]);
        System.out.println("  Opcode.BIPUSH)        \t" + Opcode.STACK_GROW[16]);
        System.out.println("  Opcode.SIPUSH)        \t" + Opcode.STACK_GROW[17]);
        System.out.println("  Opcode.LDC_W)         \t" + Opcode.STACK_GROW[19]);
        System.out.println("  Opcode.LDC)           \t" + Opcode.STACK_GROW[18]);
    }

    static {
        try {
            Class<?> cl = Class.forName("java.lang.ClassLoader");
            defineClass1 = SecurityActions.getDeclaredMethod(cl, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClass2 = SecurityActions.getDeclaredMethod(cl, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot initialize");
        }
        SecurityActions.setAccessible(defineClass1);
        SecurityActions.setAccessible(defineClass2);
    }
}

