/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding.managed;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.annotations.MetaMapping;
import org.jboss.services.binding.DuplicateServiceException;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.ServiceBindingManager;
import org.jboss.services.binding.ServiceBindingMetadata;
import org.jboss.services.binding.ServiceBindingStore;
import org.jboss.services.binding.ServiceBindingValueSource;
import org.jboss.services.binding.impl.PojoServiceBindingStore;
import org.jboss.services.binding.impl.ServiceBindingSet;
import org.jboss.services.binding.managed.ServiceBindingMapper;
import org.jboss.services.binding.managed.ServiceBindingMetadataMapper;
import org.jboss.services.binding.managed.ServiceBindingSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(name="ServiceBindingManager", componentType=@ManagementComponent(type="MCBean", subtype="ServiceBindingManager"), properties=ManagementProperties.EXPLICIT, description="The ServiceBindingManager enables the centralized management of ports, by service.")
public class ServiceBindingManagementObject {
    private final ServiceBindingManager bindingManager;
    private final PojoServiceBindingStore bindingStore;

    public ServiceBindingManagementObject(String serverName, Set<ServiceBindingSet> bindingSets, Set<ServiceBindingMetadata> standardBindings) {
        this.bindingStore = new PojoServiceBindingStore(bindingSets, standardBindings);
        this.bindingManager = new ServiceBindingManager(serverName, (ServiceBindingStore)this.bindingStore);
    }

    public ServiceBindingManager getServiceBindingManager() {
        return this.bindingManager;
    }

    @ManagementProperty(description="the name of the binding set the ServiceBindingManager should use when resolving bindings", use={ViewUse.CONFIGURATION}, readOnly=false)
    public String getActiveBindingSetName() {
        return this.bindingManager.getServerName();
    }

    public void setActiveBindingSetName(String name) {
        this.bindingManager.setServerName(name);
    }

    @ManagementProperty(description="the set of service binding configurations associated with this instance", use={ViewUse.STATISTIC}, readOnly=true)
    @MetaMapping(value=ServiceBindingMapper.class)
    public Map<String, Set<ServiceBinding>> getServiceBindings() {
        HashMap<String, Set<ServiceBinding>> result = new HashMap<String, Set<ServiceBinding>>();
        for (ServiceBindingSet set : this.getBindingSets()) {
            String name = set.getName();
            result.put(name, this.bindingStore.getServiceBindings(name));
        }
        return result;
    }

    @ManagementProperty(description="the named binding sets")
    @MetaMapping(value=ServiceBindingSetMapper.class)
    public Set<ServiceBindingSet> getBindingSets() {
        return this.bindingStore.getServiceBindingSets();
    }

    public void setBindingSets(Set<ServiceBindingSet> bindingSets) throws UnknownHostException, DuplicateServiceException {
        this.restoreOverrideBindingValueSources(bindingSets);
        this.bindingStore.setServiceBindingSets(bindingSets);
    }

    @ManagementProperty(description="the base set of bindings that should be associated with each binding set")
    @MetaMapping(value=ServiceBindingMetadataMapper.class)
    public Set<ServiceBindingMetadata> getStandardBindings() {
        return this.bindingStore.getStandardBindings();
    }

    public void setStandardBindings(Set<ServiceBindingMetadata> bindings) throws UnknownHostException, DuplicateServiceException {
        this.restoreStandardBindingValueSources(bindings);
        this.bindingStore.setStandardBindings(bindings);
    }

    private void restoreStandardBindingValueSources(Set<ServiceBindingMetadata> bindings) {
        if (bindings != null) {
            Set existing = this.bindingStore.getStandardBindings();
            this.restoreServiceBindingValueSources(bindings, existing);
        }
    }

    private void restoreOverrideBindingValueSources(Set<ServiceBindingSet> bindingSets) {
        if (bindingSets != null) {
            Set existingSets = this.bindingStore.getServiceBindingSets();
            HashMap<String, Set> byName = new HashMap<String, Set>();
            for (ServiceBindingSet set : existingSets) {
                byName.put(set.getName(), set.getOverrideBindings());
            }
            for (ServiceBindingSet set : bindingSets) {
                this.restoreServiceBindingValueSources(set.getOverrideBindings(), (Set)byName.get(set.getName()));
            }
        }
    }

    private void restoreServiceBindingValueSources(Set<ServiceBindingMetadata> bindings, Set<ServiceBindingMetadata> existing) {
        if (bindings != null && existing != null) {
            HashMap<String, ServiceBindingMetadata> byFQN = new HashMap<String, ServiceBindingMetadata>();
            for (ServiceBindingMetadata md : existing) {
                byFQN.put(md.getFullyQualifiedName(), md);
            }
            for (ServiceBindingMetadata newMD : bindings) {
                ServiceBindingMetadata old = (ServiceBindingMetadata)byFQN.get(newMD.getFullyQualifiedName());
                if (old == null) continue;
                ServiceBindingValueSource source = old.getServiceBindingValueSource();
                if (source != null) {
                    newMD.setServiceBindingValueSource(source);
                } else {
                    String sourceClass = old.getServiceBindingValueSourceClassName();
                    if (sourceClass != null) {
                        newMD.setServiceBindingValueSourceClassName(sourceClass);
                    }
                }
                newMD.setServiceBindingValueSourceConfig(old.getServiceBindingValueSourceConfig());
            }
        }
    }

    public void start() throws Exception {
        this.bindingStore.start();
    }

    public void stop() throws Exception {
        this.bindingStore.stop();
    }
}

