/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.Advised;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.versioned.DistributedFieldUpdate;
import org.jboss.aspects.versioned.DistributedPOJOUpdate;
import org.jboss.aspects.versioned.DistributedState;
import org.jboss.aspects.versioned.DistributedUpdate;
import org.jboss.aspects.versioned.DistributedVersionManager;
import org.jboss.aspects.versioned.OptimisticLockFailure;
import org.jboss.aspects.versioned.StateManager;
import org.jboss.aspects.versioned.SynchronizationManager;
import org.jboss.aspects.versioned.VersionReference;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;
import org.jboss.util.id.GUID;

public class DistributedPOJOState
extends StateManager
implements DistributedState,
Externalizable {
    private static final long serialVersionUID = 7640633352012924284L;
    private static Logger log = Logger.getLogger(DistributedPOJOState.class);
    protected String classname;
    protected HashMap fieldMap;
    protected transient TransactionManager tm;
    protected transient WeakReference advisedRef;
    protected transient TransactionLocal txState = new TransactionLocal();
    protected transient SynchronizationManager synchManager;
    protected transient DistributedVersionManager versionManager;

    public DistributedPOJOState() {
    }

    public DistributedPOJOState(GUID daguid, long datimeout, Advised advised, DistributedVersionManager versionManager, SynchronizationManager synchManager) throws Exception {
        super(daguid, datimeout);
        this.fieldMap = new HashMap();
        this.classname = advised.getClass().getName();
        InitialContext ctx = new InitialContext();
        this.tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
        this.synchManager = synchManager;
        this.versionManager = versionManager;
        this.advisedRef = new WeakReference<Advised>(advised);
    }

    public InstanceAdvised getObject() {
        if (this.advisedRef != null) {
            return (InstanceAdvised)this.advisedRef.get();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DistributedPOJOState)) {
            return false;
        }
        DistributedPOJOState pojo = (DistributedPOJOState)obj;
        return this.guid.equals((Object)pojo.guid);
    }

    public int hashCode() {
        return this.guid.hashCode();
    }

    public InstanceAdvised buildObject(SynchronizationManager manager, DistributedVersionManager versionManager) throws Exception {
        log.trace((Object)("building a " + this.classname + " of guid " + this.guid));
        this.versionManager = versionManager;
        this.synchManager = manager;
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.classname);
        Advised advised = (Advised)clazz.newInstance();
        this.advisedRef = new WeakReference<Advised>(advised);
        versionManager.addVersioning(this, advised);
        manager.putState(this.guid, this);
        manager.putObject(this.guid, advised);
        for (DistributedFieldUpdate update : this.fieldMap.values()) {
            ClassAdvisor advisor = (ClassAdvisor)advised._getAdvisor();
            log.trace((Object)("build field " + advisor.getAdvisedFields()[update.getFieldIndex()].getName()));
            Object val = update.getNonDereferencedValue();
            if (val == null || !(val instanceof VersionReference)) continue;
            VersionReference ref = (VersionReference)val;
            log.trace((Object)("VersionReference.guid: " + ref.getGUID() + " for field " + advisor.getAdvisedFields()[update.getFieldIndex()].getName()));
            val = manager.getObject(ref.getGUID());
            if (val == null) {
                DistributedState fieldVal = manager.getState(ref.getGUID());
                val = fieldVal.buildObject(manager, versionManager);
            }
            ref.set((InstanceAdvised)val);
        }
        return advised;
    }

    public HashMap getTxState() {
        return (HashMap)this.txState.get();
    }

    public HashMap getTxState(Transaction tx) {
        return (HashMap)this.txState.get(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fieldRead(Invocation invocation) throws Throwable {
        this.acquireReadLock();
        try {
            Object val;
            FieldReadInvocation fieldInvocation = (FieldReadInvocation)invocation;
            Integer index = new Integer(fieldInvocation.getIndex());
            HashMap map = this.getTxState();
            if (map == null) {
                map = this.fieldMap;
            }
            DistributedFieldUpdate update = (DistributedFieldUpdate)map.get(index);
            Object object = val = update.getValue();
            return object;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fieldWrite(Invocation invocation) throws Throwable {
        Transaction tx;
        FieldWriteInvocation fieldInvocation = (FieldWriteInvocation)invocation;
        Integer index = new Integer(fieldInvocation.getIndex());
        Object val = fieldInvocation.getValue();
        if (val instanceof Advised) {
            Advised advisedValue = (Advised)val;
            val = this.versionManager.makeVersioned(advisedValue);
        }
        if ((tx = this.tm.getTransaction()) == null) {
            this.acquireWriteLock();
            try {
                DistributedFieldUpdate update = (DistributedFieldUpdate)this.fieldMap.get(index);
                long versionId = update.getVersionId() + 1L;
                update.setVersionId(versionId);
                update.setValue(val);
                HashMap<Integer, DistributedFieldUpdate> fieldUpdates = new HashMap<Integer, DistributedFieldUpdate>();
                fieldUpdates.put(index, update);
                this.synchManager.noTxUpdate(new DistributedPOJOUpdate(this.guid, fieldUpdates));
                Object var10_12 = null;
                return var10_12;
            }
            finally {
                this.releaseWriteLock();
            }
        }
        this.acquireReadLock();
        try {
            HashMap<Integer, DistributedFieldUpdate> map = (HashMap<Integer, DistributedFieldUpdate>)this.txState.get();
            if (map == null) {
                map = new HashMap<Integer, DistributedFieldUpdate>();
                DistributedFieldUpdate update = (DistributedFieldUpdate)this.fieldMap.get(index);
                DistributedFieldUpdate newUpdate = new DistributedFieldUpdate(val, update.getVersionId() + 1L, index);
                this.synchManager.registerUpdate(tx, this);
                map.put(index, newUpdate);
                this.txState.set(tx, map);
            } else {
                DistributedFieldUpdate newUpdate = (DistributedFieldUpdate)map.get(index);
                if (newUpdate == null) {
                    DistributedFieldUpdate update = (DistributedFieldUpdate)this.fieldMap.get(index);
                    newUpdate = new DistributedFieldUpdate(val, update.getVersionId() + 1L, index);
                    map.put(index, newUpdate);
                } else {
                    newUpdate.setValue(val);
                }
            }
        }
        finally {
            this.releaseReadLock();
        }
        return null;
    }

    public DistributedUpdate createTxUpdate(Transaction tx) {
        HashMap state = this.getTxState(tx);
        return new DistributedPOJOUpdate(this.guid, state);
    }

    public void checkOptimisticLock(Transaction tx) {
        HashMap state = this.getTxState(tx);
        for (Map.Entry entry : state.entrySet()) {
            Integer index = (Integer)entry.getKey();
            DistributedFieldUpdate update = (DistributedFieldUpdate)entry.getValue();
            DistributedFieldUpdate orig = (DistributedFieldUpdate)this.fieldMap.get(index);
            if (update.getVersionId() > orig.getVersionId()) continue;
            Advised advised = null;
            if (this.advisedRef != null) {
                advised = (Advised)this.advisedRef.get();
            }
            if (advised == null) continue;
            ClassAdvisor advisor = (ClassAdvisor)advised._getAdvisor();
            Field field = advisor.getAdvisedFields()[index];
            throw new OptimisticLockFailure("optimistic lock failure for field " + field.getName() + " of class " + field.getDeclaringClass().getName());
        }
    }

    public void mergeState(Transaction tx) throws Exception {
        HashMap newState = this.getTxState(tx);
        this.mergeState(newState);
    }

    public void mergeState(DistributedUpdate update) throws Exception {
        HashMap newState = ((DistributedPOJOUpdate)update).fieldUpdates;
        this.mergeState(newState);
    }

    public void mergeState(HashMap newState) throws Exception {
        for (Map.Entry entry : newState.entrySet()) {
            VersionReference ref;
            DistributedFieldUpdate update = (DistributedFieldUpdate)entry.getValue();
            if (!(update.getNonDereferencedValue() instanceof VersionReference) || (ref = (VersionReference)update.getNonDereferencedValue()).get() != null) continue;
            ref.set((InstanceAdvised)this.synchManager.getObject(ref.getGUID()));
        }
        this.fieldMap.putAll(newState);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.classname);
        out.writeObject(this.fieldMap);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.classname = (String)in.readObject();
        this.fieldMap = (HashMap)in.readObject();
        try {
            InitialContext ctx = new InitialContext();
            this.tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.txState = new TransactionLocal();
    }
}

