/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.junit;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.net.URL;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.test.AbstractTestDelegate;

public class AOPTestDelegate
extends AbstractTestDelegate {
    private static final CopyOnWriteArrayList urls = new CopyOnWriteArrayList();

    public AOPTestDelegate(Class clazz) throws Exception {
        super(clazz);
    }

    public void setUp() throws Exception {
        super.setUp();
        try {
            this.deploy();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.undeploy();
    }

    protected void deploy() throws Exception {
        String testName = this.clazz.getName();
        testName = testName.replace('.', '/') + "-aop.xml";
        URL url = this.clazz.getClassLoader().getResource(testName);
        if (url != null) {
            this.deploy(url);
        } else {
            this.log.debug((Object)("No test specific deployment " + testName));
        }
    }

    protected void undeploy() {
        for (URL url : urls) {
            this.undeploy(url);
        }
    }

    protected void deploy(URL url) throws Exception {
        this.log.debug((Object)("Deploying " + url));
        urls.add((Object)url);
        AspectXmlLoader.deployXML((URL)url);
    }

    protected void undeploy(URL url) {
        try {
            this.log.debug((Object)("Undeploying " + url));
            urls.remove((Object)url);
            AspectXmlLoader.undeployXML((URL)url);
        }
        catch (Exception e) {
            this.log.warn((Object)("Ignored error undeploying " + url), (Throwable)e);
        }
    }
}

