/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.deployers.vfs.spi.structure.modified.SynchAdapter;
import org.jboss.logging.Logger;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public abstract class AbstractSynchAdapter
implements SynchAdapter {
    protected static Logger log = Logger.getLogger(AbstractSynchAdapter.class);

    public long add(VirtualFile fileToAdd, VirtualFile tempRoot, String pathToFile) throws IOException {
        File rootDir = tempRoot.getPhysicalFile();
        File newFile = new File(rootDir, pathToFile);
        return AbstractSynchAdapter.copy(fileToAdd, newFile);
    }

    protected static long copy(VirtualFile fileToAdd, File newFile) throws IOException {
        FileOutputStream out = new FileOutputStream(newFile);
        VFSUtils.copyStreamAndClose((InputStream)fileToAdd.openStream(), (OutputStream)out);
        return newFile.lastModified();
    }

    public boolean delete(VirtualFile fileToDelete) throws IOException {
        return fileToDelete.delete();
    }

    static class MergeException
    extends IOException {
        private static final long serialVersionUID = 5228888050899870372L;

        MergeException(VirtualFile dest, VirtualFile source, Exception cause) {
            super("Conflict merging files, dest: " + dest + ", source: " + source);
            this.initCause(cause);
        }
    }
}

