/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.artifact.maven;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.jboss.profileservice.repository.artifact.maven.MavenArtifactId;

public class MavenArtifactMetaData
implements MavenArtifactId {
    private static final long serialVersionUID = -4126849949276732212L;
    public static final String DEFAULT_PACKAGING = "jar";
    private String groupId;
    private String artifactId;
    private String classifier;
    private String version;
    private String packagingType;

    public MavenArtifactMetaData() {
        this.packagingType = DEFAULT_PACKAGING;
    }

    public MavenArtifactMetaData(String groupId, String artifactId) {
        this(groupId, artifactId, DEFAULT_PACKAGING);
    }

    public MavenArtifactMetaData(String groupId, String artifactId, String packaging) {
        if (groupId == null) {
            throw new IllegalArgumentException("null group id");
        }
        if (artifactId == null) {
            throw new IllegalArgumentException("null artifact id");
        }
        if (packaging == null) {
            throw new IllegalArgumentException("null packaging");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.packagingType = packaging;
    }

    @XmlTransient
    public String getType() {
        return TYPE;
    }

    @Override
    @XmlAttribute(name="groupId")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    @XmlAttribute(name="artifactId")
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlAttribute(name="version")
    public String getVersion() {
        return this.version;
    }

    @Override
    @XmlAttribute(name="classifier")
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Override
    @XmlAttribute(name="packaging")
    public String getPackagingType() {
        return this.packagingType;
    }

    public void setPackagingType(String packaging) {
        this.packagingType = packaging;
    }

    public int hashCode() {
        int result = 17;
        if (this.groupId != null) {
            result = 31 * result + this.groupId.hashCode();
        }
        if (this.artifactId != null) {
            result = 31 * result + this.artifactId.hashCode();
        }
        if (this.classifier != null) {
            result = 31 * result + this.classifier.hashCode();
        }
        if (this.packagingType != null) {
            result = 31 * result + this.packagingType.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof MavenArtifactMetaData)) {
            return false;
        }
        MavenArtifactMetaData other = (MavenArtifactMetaData)obj;
        if (!MavenArtifactMetaData.equals(this.getGroupId(), other.getGroupId())) {
            return false;
        }
        if (!MavenArtifactMetaData.equals(this.getArtifactId(), other.getArtifactId())) {
            return false;
        }
        if (!MavenArtifactMetaData.equals(this.getClassifier(), other.getClassifier())) {
            return false;
        }
        if (!MavenArtifactMetaData.equals(this.getPackagingType(), other.getPackagingType())) {
            return false;
        }
        return super.equals(other);
    }

    protected static boolean equals(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null && two != null) {
            return false;
        }
        return one.equals(two);
    }

    @Override
    public boolean matches(MavenArtifactId artifact) {
        return this.equals(artifact);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("{");
        this.toString(buffer);
        buffer.append("}");
        return buffer.toString();
    }

    protected void toString(StringBuffer buffer) {
        buffer.append("group=").append(this.getGroupId());
        buffer.append(", artifact=").append(this.getGroupId());
    }
}

