/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.profile.metadata;

import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragment;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragmentVisitor;
import org.jboss.profileservice.profile.metadata.BasicProfileDeploymentMetaData;
import org.jboss.profileservice.profile.metadata.BasicSubProfileMetaData;
import org.jboss.profileservice.profile.metadata.FeatureCapability;
import org.jboss.profileservice.profile.metadata.FeatureRequirement;
import org.jboss.profileservice.profile.metadata.FileRepositorySourceConfiguration;
import org.jboss.profileservice.profile.metadata.VirtualProfileDeploymentMetaData;
import org.jboss.profileservice.profile.metadata.helpers.AbstractProfileMetaData;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;
import org.jboss.profileservice.spi.metadata.ProfileDeploymentMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaDataVisitor;
import org.jboss.profileservice.spi.metadata.ProfileMetaDataVisitorNode;
import org.jboss.xb.annotations.JBossXmlSchema;

@JBossXmlSchema(namespace="urn:jboss:profileservice:profile:1.0", elementFormDefault=XmlNsForm.QUALIFIED, normalizeSpace=true, replacePropertyRefs=false)
@XmlRootElement(name="profile")
@XmlType(name="profileType", propOrder={"aliases", "source", "deployments", "features"})
public class BasicProfileMetaData
extends AbstractProfileMetaData
implements ProfileMetaData,
DomainMetaDataFragment {
    private static FeatureRequirement REQUIREMENT = new FeatureRequirement("urn:jboss:profileservice:profile:1.0");
    private List<String> aliases;
    private FileRepositorySourceConfiguration source;
    private List<ProfileDeploymentMetaData> deployments;

    public List<ProfileDeploymentMetaData> getDeployments() {
        return this.deployments;
    }

    @Override
    public boolean isCheckComplete() {
        return false;
    }

    @Override
    @XmlAttribute(name="name")
    public String getName() {
        return super.getName();
    }

    @XmlElement(name="alias")
    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    @Override
    @XmlElements(value={@XmlElement(name="requires", type=BasicSubProfileMetaData.class), @XmlElement(name="management", type=FeatureCapability.class)})
    public List<ProfileMetaDataVisitorNode> getFeatures() {
        return super.getFeatures();
    }

    @XmlElements(value={@XmlElement(name="deployment", type=BasicProfileDeploymentMetaData.class), @XmlElement(name="virtual-deployment", type=VirtualProfileDeploymentMetaData.class)})
    public void setDeployments(List<ProfileDeploymentMetaData> deployments) {
        this.deployments = deployments;
    }

    @XmlElement(name="file-repository", type=FileRepositorySourceConfiguration.class)
    public FileRepositorySourceConfiguration getSource() {
        return this.source;
    }

    public void setSource(FileRepositorySourceConfiguration source) {
        this.source = source;
    }

    @Override
    public void visit(ProfileMetaDataVisitor visitor) {
        List<ProfileDeploymentMetaData> deployments;
        super.visit(visitor);
        visitor.addRequirement((ProfileRequirement)REQUIREMENT);
        if (this.aliases != null && !this.aliases.isEmpty()) {
            for (String alias : this.aliases) {
                visitor.addAlias(alias);
            }
        }
        if ((deployments = this.getDeployments()) != null && !deployments.isEmpty()) {
            for (ProfileDeploymentMetaData deployment : deployments) {
                visitor.visit((ProfileMetaDataVisitorNode)deployment);
            }
        }
    }

    public void visit(DomainMetaDataFragmentVisitor visitor) {
        visitor.addProfileMetaData((ProfileMetaData)this);
    }

    public String getNameSpace() {
        return "urn:jboss:profileservice:profile:1.0";
    }
}

