/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.impl.base.scanner;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    static String getSystemProperty(final String key) {
        assert (key != null && key.length() > 0) : "Key must be specified";
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }

    static ClassLoader getTccl() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

