/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import org.jboss.ejb3.annotation.Service;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBossManagementProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.StatefulProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossServiceBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

public class JBossServiceProcessor
extends StatefulProcessor
implements Processor<JBossMetaData, Class<?>> {
    protected JBossServiceProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.addTypeProcessor(new JBossManagementProcessor(finder));
    }

    @Override
    public JBossSessionBeanMetaData create(Class<?> beanClass) {
        Service annotation = (Service)this.finder.getAnnotation(beanClass, Service.class);
        if (annotation == null) {
            return null;
        }
        JBossServiceBeanMetaData bean = new JBossServiceBeanMetaData();
        bean.setEjbClass(beanClass.getName());
        String ejbName = annotation.name() == null || annotation.name().length() == 0 ? beanClass.getSimpleName() : annotation.name();
        bean.setEjbName(ejbName);
        bean.setObjectName(annotation.objectName());
        bean.setXmbean(annotation.xmbean());
        TransactionManagement txMgmt = (TransactionManagement)this.finder.getAnnotation(beanClass, TransactionManagement.class);
        TransactionManagementType txType = TransactionManagementType.CONTAINER;
        if (txMgmt != null) {
            txType = txMgmt.value();
        }
        bean.setTransactionType(txType);
        return bean;
    }

    @Override
    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(Service.class);
    }
}

