/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.reflect.AnnotatedElement;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.jboss.AbstractComponentProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;

public class InterceptorComponentProcessor<MD extends InterceptorsMetaData>
extends AbstractComponentProcessor<MD>
implements Processor<MD, Class<?>> {
    public InterceptorComponentProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public void process(MD interceptors, Class<?> interceptorClass) {
        InterceptorMetaData interceptor = this.createInterceptorMetaData(interceptorClass);
        interceptors.add((MappableMetaData)interceptor);
        EnvironmentRefsGroupMetaData environmentRefsGroup = interceptor.getJndiEnvironmentRefsGroup();
        if (environmentRefsGroup == null) {
            environmentRefsGroup = new EnvironmentRefsGroupMetaData();
            interceptor.setJndiEnvironmentRefsGroup(environmentRefsGroup);
        }
        super.process((RemoteEnvironmentRefsGroupMetaData)environmentRefsGroup, interceptorClass);
        PersistenceContextReferencesMetaData pcRefs = interceptor.getPersistenceContextRefs();
        if (pcRefs == null) {
            pcRefs = new PersistenceContextReferencesMetaData();
            environmentRefsGroup.setPersistenceContextRefs(pcRefs);
        }
        this.processClass(pcRefs, interceptorClass);
    }

    private InterceptorMetaData createInterceptorMetaData(Class<?> interceptorClass) {
        InterceptorMetaData interceptor = new InterceptorMetaData();
        interceptor.setInterceptorClass(interceptorClass.getName());
        return interceptor;
    }
}

