/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util.threadpool;

import java.util.LinkedList;
import org.jacorb.config.Configuration;
import org.jacorb.util.threadpool.ConsumerFactory;
import org.jacorb.util.threadpool.ConsumerTie;
import org.omg.CORBA.NO_RESOURCES;
import org.slf4j.Logger;

public class ThreadPool {
    private final int max_threads;
    private final int max_idle_threads;
    private int total_threads = 0;
    private int idle_threads = 0;
    private final LinkedList job_queue;
    private final ConsumerFactory factory;
    private final String namePrefix;
    private int threadCount = 0;
    private final Logger logger;
    private boolean shutdown;

    public ThreadPool(Configuration configuration, String string, ConsumerFactory consumerFactory, int n, int n2) {
        this.namePrefix = string;
        this.job_queue = new LinkedList();
        this.factory = consumerFactory;
        this.max_threads = n;
        this.max_idle_threads = n2;
        this.logger = configuration.getLogger("jacorb.util.tpool");
    }

    protected synchronized Object getJob() {
        ++this.idle_threads;
        while (!this.shutdown && this.job_queue.isEmpty()) {
            if (this.idle_threads > this.max_idle_threads) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] Telling thread to exit (too many idle)");
                }
                return this.getShutdownJob();
            }
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] job queue empty");
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.shutdown) {
            return this.getShutdownJob();
        }
        --this.idle_threads;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] removed idle thread (job scheduled)");
        }
        return this.job_queue.removeFirst();
    }

    private Object getShutdownJob() {
        --this.total_threads;
        --this.idle_threads;
        return null;
    }

    public synchronized void putJob(Object object) {
        this.job_queue.add(object);
        this.notifyAll();
        if (this.job_queue.size() > this.idle_threads && this.total_threads < this.max_threads) {
            this.createNewThread();
        } else if (this.job_queue.size() > this.idle_threads) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("(Pool)[" + this.idle_threads + "/" + this.total_threads + "] no idle threads but maximum number of threads reached (" + this.max_threads + ")");
            }
            this.job_queue.remove(object);
            throw new NO_RESOURCES("(Pool)[" + this.idle_threads + "/" + this.total_threads + "] no idle threads but maximum number of threads reached (" + this.max_threads + ")");
        }
    }

    private void createNewThread() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] creating new thread");
        }
        Thread thread = new Thread(new ConsumerTie(this, this.factory.create()));
        thread.setName(this.namePrefix + this.threadCount++);
        thread.setDaemon(true);
        thread.start();
        ++this.total_threads;
    }

    Logger getLogger() {
        return this.logger;
    }

    public synchronized void shutdown() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] shutting down pool");
        }
        this.shutdown = true;
        this.notifyAll();
    }
}

