/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.List;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.poa.POA;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.slf4j.Logger;

public class ServerRequestListener
implements RequestListener,
Configurable {
    private final ORB orb;
    private final POA rootPOA;
    private Logger logger = null;
    private boolean require_ssl = false;

    public ServerRequestListener(ORB oRB, POA pOA) {
        this.orb = oRB;
        this.rootPOA = pOA;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration configuration2 = configuration;
        this.logger = configuration2.getLogger("jacorb.giop.server.listener");
        boolean bl = configuration2.getAttribute("jacorb.security.support_ssl", "off").equals("on");
        if (bl) {
            int n = configuration2.getAttributeAsInteger("jacorb.security.ssl.server.required_options", 16);
            this.require_ssl = bl && (n & 0x60) != 0;
        }
    }

    public void requestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        Object object;
        RequestInputStream requestInputStream = new RequestInputStream(this.orb, byArray);
        if (this.require_ssl && !gIOPConnection.isSSL()) {
            ReplyOutputStream replyOutputStream = new ReplyOutputStream(requestInputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, requestInputStream.getGIOPMinor(), false, this.logger);
            this.logger.debug("About to reject request because connection is not SSL.");
            SystemExceptionHelper.write(replyOutputStream, new NO_PERMISSION(3, CompletionStatus.COMPLETED_NO));
            try {
                gIOPConnection.sendReply(replyOutputStream);
            }
            catch (IOException iOException) {
                this.logger.warn("IOException", (Throwable)iOException);
            }
            return;
        }
        if (Messages.responseExpected(requestInputStream.req_hdr.response_flags)) {
            gIOPConnection.incPendingMessages();
        }
        if (!gIOPConnection.isTCSNegotiated()) {
            if (requestInputStream.getGIOPMinor() == 0) {
                gIOPConnection.markTCSNegotiated();
            } else {
                object = CodeSet.getCodeSetContext(requestInputStream.req_hdr.service_context);
                if (object != null) {
                    gIOPConnection.setCodeSets(((CodeSetContext)object).char_data, ((CodeSetContext)object).wchar_data);
                    gIOPConnection.markTCSNegotiated();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Received CodeSetContext. Using " + CodeSet.csName(((CodeSetContext)object).char_data) + " as TCS and " + CodeSet.csName(((CodeSetContext)object).wchar_data) + " as TCSW");
                    }
                }
            }
        }
        requestInputStream.setCodeSet(gIOPConnection.getTCS(), gIOPConnection.getTCSW());
        requestInputStream.updateMutatorConnection(gIOPConnection);
        object = null;
        try {
            object = new ServerRequest(this.orb, requestInputStream, gIOPConnection);
        }
        catch (POAInternalError pOAInternalError) {
            this.logger.warn("Received a request with a non-jacorb object key");
            if (requestInputStream.isLocateRequest()) {
                LocateReplyOutputStream locateReplyOutputStream = new LocateReplyOutputStream(requestInputStream.req_hdr.request_id, 0, requestInputStream.getGIOPMinor());
                try {
                    gIOPConnection.sendReply(locateReplyOutputStream);
                }
                catch (IOException iOException) {
                    this.logger.warn("IOException", (Throwable)iOException);
                }
            } else {
                ReplyOutputStream replyOutputStream = new ReplyOutputStream(requestInputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, requestInputStream.getGIOPMinor(), false, this.logger);
                SystemExceptionHelper.write(replyOutputStream, new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO));
                try {
                    gIOPConnection.sendReply(replyOutputStream);
                }
                catch (IOException iOException) {
                    this.logger.warn("IOException", (Throwable)iOException);
                }
            }
            return;
        }
        this.deliverRequest((ServerRequest)object);
    }

    public void locateRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        this.requestReceived(byArray, gIOPConnection);
    }

    public void cancelRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
    }

    private void deliverRequest(ServerRequest serverRequest) {
        POA pOA = this.rootPOA;
        try {
            String string;
            String string2 = "";
            String string3 = this.orb.getImplName();
            String string4 = this.orb.getServerIdString();
            try {
                string2 = POAUtil.extractImplName(serverRequest.objectKey());
            }
            catch (POAInternalError pOAInternalError) {
                this.logger.debug("serverRequestListener: reference generated by foreign POA");
            }
            if (!string3.equals(string2) && !string4.equals(string2)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("serverRequestListener: impl_name mismatch (refImplName: " + string2 + " and orbServerId " + string4 + " and orbImplName " + string3);
                }
                throw new WrongAdapter();
            }
            List list = serverRequest.getScopes();
            for (int i = 0; i < list.size() && !(string = (String)list.get(i)).equals(""); ++i) {
                try {
                    pOA = pOA._getChildPOA(string);
                    continue;
                }
                catch (ParentIsHolding parentIsHolding) {
                    String[] stringArray = new String[list.size() - i];
                    for (int j = 0; j < i; ++j) {
                        stringArray[j] = (String)list.get(j + i);
                    }
                    serverRequest.setRemainingPOAName(stringArray);
                    break;
                }
            }
            if (pOA == null) {
                throw new INTERNAL("Request POA null!");
            }
            pOA._invoke(serverRequest);
        }
        catch (WrongAdapter wrongAdapter) {
            serverRequest.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
            serverRequest.reply();
        }
        catch (SystemException systemException) {
            serverRequest.setSystemException(systemException);
            serverRequest.reply();
        }
        catch (RuntimeException runtimeException) {
            serverRequest.setSystemException(new UNKNOWN(runtimeException.toString()));
            serverRequest.reply();
            this.logger.warn("unexpected exception", (Throwable)runtimeException);
        }
    }
}

