/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.ejb;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationContext;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.ServiceUnavailableException;
import org.jboss.logging.Logger;
import org.jboss.naming.NamingContextFactory;
import org.jboss.proxy.Interceptor;

public class RetryInterceptor
extends Interceptor {
    private static final long serialVersionUID = 1L;
    private static final int EXTERNAL_VERSION = 1;
    private static Logger log = Logger.getLogger(RetryInterceptor.class);
    private static Properties retryEnv;
    private transient boolean retry;
    private transient boolean trace;
    private transient int maxRetries = -1;
    private transient long sleepTime = 1000L;

    public static void setRetryEnv(Properties env) {
        retryEnv = env;
    }

    public RetryInterceptor() {
    }

    protected RetryInterceptor(int maxRetries, long sleepTime) {
        this.maxRetries = maxRetries;
        this.sleepTime = sleepTime;
    }

    public void setRetry(boolean flag) {
        this.retry = flag;
    }

    public boolean getRetry() {
        return this.retry;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object result = null;
        InvocationContext ctx = invocation.getInvocationContext();
        this.retry = true;
        int retryCount = 0;
        while (this.retry) {
            Interceptor next = this.getNext();
            try {
                if (this.trace) {
                    log.trace((Object)("invoke, method=" + invocation.getMethod()));
                }
                result = next.invoke(invocation);
                break;
            }
            catch (ServiceUnavailableException e) {
                if (this.trace) {
                    log.trace((Object)"Invocation failed", (Throwable)e);
                }
                InvocationType type = invocation.getType();
                if (this.maxRetries > -1 && retryCount >= this.maxRetries || !this.reestablishInvokerProxy(ctx, type)) {
                    throw e;
                }
                ++retryCount;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean reestablishInvokerProxy(InvocationContext ctx, InvocationType type) {
        if (this.trace) {
            log.trace((Object)"Begin reestablishInvokerProxy");
        }
        boolean isRemote = type == InvocationType.REMOTE;
        String jndiName = (String)ctx.getValue(InvocationKey.JNDI_NAME);
        jndiName = isRemote ? jndiName + "-RemoteInvoker" : jndiName + "-HomeInvoker";
        Hashtable retryProps = retryEnv;
        if (retryProps == null) {
            retryProps = (Hashtable)NamingContextFactory.lastInitialContextEnv.get();
            if (this.trace) {
                if (retryProps != null) {
                    log.trace((Object)"Using retry properties from NamingContextFactory");
                } else {
                    log.trace((Object)"No retry properties available");
                }
            }
        } else if (this.trace) {
            log.trace((Object)"Using static retry properties");
        }
        int retryCount = 0;
        Invoker newInvoker = null;
        while (this.retry) {
            InitialContext namingCtx = null;
            Thread.sleep(this.sleepTime);
            namingCtx = new InitialContext(retryProps);
            if (this.trace) {
                log.trace((Object)("Looking for invoker: " + jndiName));
            }
            newInvoker = (Invoker)namingCtx.lookup(jndiName);
            if (this.trace) {
                log.trace((Object)("Found invoker: " + newInvoker));
            }
            ctx.setInvoker(newInvoker);
            Object var11_10 = null;
            if (namingCtx == null) break;
            try {
                namingCtx.close();
            }
            catch (NamingException e) {
                log.warn((Object)("Problem closing naming context used for reaquiring invoker: " + e.getClass() + " -- " + e.getLocalizedMessage()));
            }
            break;
            {
                catch (Throwable t) {
                    ++retryCount;
                    if (this.trace) {
                        log.trace((Object)("Retry attempt " + retryCount + ": Failed to lookup proxy"), t);
                    }
                    if (this.maxRetries > -1 && retryCount >= this.maxRetries) {
                        if (this.trace) {
                            log.trace((Object)"Maximum retry attempts made");
                        }
                        var11_10 = null;
                        if (namingCtx == null) break;
                        try {
                            namingCtx.close();
                        }
                        catch (NamingException e) {
                            log.warn((Object)("Problem closing naming context used for reaquiring invoker: " + e.getClass() + " -- " + e.getLocalizedMessage()));
                        }
                        break;
                    }
                    var11_10 = null;
                    if (namingCtx == null) continue;
                    try {
                        namingCtx.close();
                    }
                    catch (NamingException e) {
                        log.warn((Object)("Problem closing naming context used for reaquiring invoker: " + e.getClass() + " -- " + e.getLocalizedMessage()));
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_10 = null;
                if (namingCtx != null) {
                    try {
                        namingCtx.close();
                    }
                    catch (NamingException e) {
                        log.warn((Object)("Problem closing naming context used for reaquiring invoker: " + e.getClass() + " -- " + e.getLocalizedMessage()));
                    }
                }
                throw throwable;
            }
        }
        if (this.trace) {
            log.trace((Object)"End reestablishInvokerProxy");
        }
        return newInvoker != null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(1);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int version = in.readInt();
        if (version == 1) {
            // empty if block
        }
        this.trace = log.isTraceEnabled();
    }
}

