/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.security;

import java.lang.reflect.Method;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.security.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityIdentity;

public class PreSecurityInterceptor
extends AbstractInterceptor {
    private String securityDomain = null;
    private String timedObjectMethod = null;

    public void setContainer(Container container) {
        AuthenticationManager am;
        super.setContainer(container);
        if (container != null && (am = container.getSecurityManager()) != null) {
            this.securityDomain = am.getSecurityDomain();
        }
        try {
            this.timedObjectMethod = TimedObject.class.getMethod("ejbTimeout", Timer.class).getName();
        }
        catch (Exception e) {
            this.log.trace((Object)"Exception in creating TimedObject method:", (Throwable)e);
        }
    }

    public Object invoke(Invocation mi) throws Exception {
        boolean isInvoke = true;
        return this.process(mi, isInvoke);
    }

    public Object invokeHome(Invocation mi) throws Exception {
        boolean isInvoke = false;
        return this.process(mi, isInvoke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object process(Invocation mi, boolean isInvoke) throws Exception {
        String incomingDomain;
        SecurityIdentity si;
        block14: {
            Object object;
            boolean isEjbTimeOutMethod;
            if (this.securityDomain == null) {
                if (isInvoke) {
                    return this.getNext().invoke(mi);
                }
                return this.getNext().invokeHome(mi);
            }
            this.log.trace((Object)("process:isInvoke=" + isInvoke + " bean=" + this.container.getServiceName()));
            si = null;
            incomingDomain = null;
            Method m = mi.getMethod();
            boolean bl = isEjbTimeOutMethod = m != null && m.getName().equals(this.timedObjectMethod);
            if (mi.isLocal() && !isEjbTimeOutMethod) {
                this.log.trace((Object)"True mi.isLocal() && !isEjbTimeOutMethod");
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc != null) {
                    si = SecurityActions.getSecurityIdentity(sc);
                    incomingDomain = sc.getSecurityDomain();
                }
                SecurityActions.setSecurityManagement(sc, this.container.getSecurityManagement());
                SecurityActions.setSecurityDomain(sc, this.securityDomain);
                this.log.trace((Object)("SecurityIdentity=" + SecurityActions.trace(si)));
                mi.setSecurityContext(sc);
            } else {
                this.log.trace((Object)"False mi.isLocal() && !isEjbTimeOutMethod");
                this.establishSecurityContext(mi);
            }
            try {
                SecurityContext currentSC = SecurityActions.getSecurityContext();
                SecurityActions.pushCallerRunAsIdentity(currentSC.getOutgoingRunAs());
                this.log.trace((Object)("Going to the SecurityInterceptor with SC=" + SecurityActions.trace(currentSC)));
                if (!isInvoke) break block14;
                object = this.getNext().invoke(mi);
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                SecurityActions.popCallerRunAsIdentity();
                if (mi.isLocal() && si != null) {
                    SecurityActions.setSecurityIdentity(SecurityActions.getSecurityContext(), si);
                }
                if (mi.isLocal() && incomingDomain != null) {
                    SecurityActions.setSecurityDomain(SecurityActions.getSecurityContext(), incomingDomain);
                }
                this.log.trace((Object)("Exit process():isInvoke=" + isInvoke));
                throw throwable;
            }
            SecurityActions.popCallerRunAsIdentity();
            if (mi.isLocal() && si != null) {
                SecurityActions.setSecurityIdentity(SecurityActions.getSecurityContext(), si);
            }
            if (mi.isLocal() && incomingDomain != null) {
                SecurityActions.setSecurityDomain(SecurityActions.getSecurityContext(), incomingDomain);
            }
            this.log.trace((Object)("Exit process():isInvoke=" + isInvoke));
            return object;
        }
        Object object = this.getNext().invokeHome(mi);
        Object var10_11 = null;
        SecurityActions.popCallerRunAsIdentity();
        if (mi.isLocal() && si != null) {
            SecurityActions.setSecurityIdentity(SecurityActions.getSecurityContext(), si);
        }
        if (mi.isLocal() && incomingDomain != null) {
            SecurityActions.setSecurityDomain(SecurityActions.getSecurityContext(), incomingDomain);
        }
        this.log.trace((Object)("Exit process():isInvoke=" + isInvoke));
        return object;
    }

    private void establishSecurityContext(Invocation mi) throws Exception {
        SecurityContext sc = mi.getSecurityContext();
        SecurityContext newSC = SecurityActions.createAndSetSecurityContext(this.securityDomain, this.container.getSecurityContextClassName());
        if (sc != null) {
            SecurityActions.setSecurityIdentity(newSC, SecurityActions.getSecurityIdentity(sc));
        } else {
            mi.setSecurityContext(newSC);
        }
        SecurityActions.setSecurityManagement(newSC, this.container.getSecurityManagement());
        this.log.trace((Object)("establishSecurityIdentity:SecCtx=" + SecurityActions.trace(newSC)));
    }
}

