/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.lang.reflect.Method;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.metadata.QueryMetaData;

public final class JDBCQlQueryMetaData
implements JDBCQueryMetaData {
    private final Method method;
    private final String ejbQl;
    private final boolean resultTypeMappingLocal;
    private final JDBCReadAheadMetaData readAhead;
    private final Class compiler;
    private final boolean lazyResultSetLoading;

    public JDBCQlQueryMetaData(QueryMetaData queryMetaData, Method method, Class qlCompiler, boolean lazyResultSetLoading) {
        this.method = method;
        this.readAhead = JDBCReadAheadMetaData.DEFAULT;
        this.ejbQl = queryMetaData.getEjbQl();
        this.resultTypeMappingLocal = queryMetaData.getResultTypeMapping().equals("Local");
        this.compiler = qlCompiler;
        this.lazyResultSetLoading = lazyResultSetLoading;
    }

    public JDBCQlQueryMetaData(JDBCQlQueryMetaData defaults, JDBCReadAheadMetaData readAhead, Class compiler, boolean lazyResultSetLoading) {
        this.method = defaults.getMethod();
        this.readAhead = readAhead;
        this.ejbQl = defaults.getEjbQl();
        this.resultTypeMappingLocal = defaults.resultTypeMappingLocal;
        this.compiler = compiler;
        this.lazyResultSetLoading = lazyResultSetLoading;
    }

    public JDBCQlQueryMetaData(JDBCQlQueryMetaData jdbcQueryMetaData, Method method, JDBCReadAheadMetaData readAhead) {
        this.method = method;
        this.readAhead = readAhead;
        this.ejbQl = jdbcQueryMetaData.getEjbQl();
        this.resultTypeMappingLocal = jdbcQueryMetaData.resultTypeMappingLocal;
        this.compiler = jdbcQueryMetaData.compiler;
        this.lazyResultSetLoading = jdbcQueryMetaData.lazyResultSetLoading;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class getQLCompilerClass() {
        return this.compiler;
    }

    public String getEjbQl() {
        return this.ejbQl;
    }

    public boolean isResultTypeMappingLocal() {
        return this.resultTypeMappingLocal;
    }

    public JDBCReadAheadMetaData getReadAhead() {
        return this.readAhead;
    }

    public boolean isLazyResultSetLoading() {
        return this.lazyResultSetLoading;
    }

    public boolean equals(Object o) {
        if (o instanceof JDBCQlQueryMetaData) {
            return ((JDBCQlQueryMetaData)o).method.equals(this.method);
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public String toString() {
        return "[JDBCQlQueryMetaData : method=" + this.method + "]";
    }
}

