/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCLeftJoinMetaData {
    private final String cmrField;
    private final String eagerLoadGroup;
    private final List leftJoinList;

    public static List readLeftJoinList(Iterator leftJoinIterator) throws DeploymentException {
        ArrayList<JDBCLeftJoinMetaData> leftJoinList;
        if (leftJoinIterator.hasNext()) {
            leftJoinList = new ArrayList<JDBCLeftJoinMetaData>();
            while (leftJoinIterator.hasNext()) {
                Element leftJoinElement = (Element)leftJoinIterator.next();
                JDBCLeftJoinMetaData leftJoin = new JDBCLeftJoinMetaData(leftJoinElement);
                leftJoinList.add(leftJoin);
            }
        } else {
            leftJoinList = Collections.EMPTY_LIST;
        }
        return leftJoinList;
    }

    public JDBCLeftJoinMetaData(String cmrField, String eagerLoadGroup, List leftJoinList) {
        this.cmrField = cmrField;
        this.eagerLoadGroup = eagerLoadGroup;
        this.leftJoinList = leftJoinList;
    }

    public JDBCLeftJoinMetaData(Element element) throws DeploymentException {
        this.cmrField = element.getAttribute("cmr-field");
        if (this.cmrField == null || this.cmrField.trim().length() == 0) {
            throw new DeploymentException("left-join MUST have non-empty cmr-field attribute.");
        }
        String eagerLoadGroup = element.getAttribute("eager-load-group");
        this.eagerLoadGroup = eagerLoadGroup == null || eagerLoadGroup.trim().length() == 0 ? "*" : eagerLoadGroup;
        Iterator leftJoinIterator = MetaData.getChildrenByTagName((Element)element, (String)"left-join");
        this.leftJoinList = JDBCLeftJoinMetaData.readLeftJoinList(leftJoinIterator);
    }

    public String getCmrField() {
        return this.cmrField;
    }

    public String getEagerLoadGroup() {
        return this.eagerLoadGroup;
    }

    public Iterator getLeftJoins() {
        return this.leftJoinList.iterator();
    }

    public boolean equals(Object o) {
        boolean result;
        if (o == this) {
            result = true;
        } else if (o instanceof JDBCLeftJoinMetaData) {
            JDBCLeftJoinMetaData other = (JDBCLeftJoinMetaData)o;
            result = (this.cmrField == null ? other.cmrField == null : this.cmrField.equals(other.cmrField)) && (this.eagerLoadGroup == null ? other.eagerLoadGroup == null : this.eagerLoadGroup.equals(other.eagerLoadGroup)) && (this.leftJoinList == null ? other.leftJoinList == null : ((Object)this.leftJoinList).equals(other.leftJoinList));
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int result = Integer.MIN_VALUE;
        result += this.cmrField == null ? 0 : this.cmrField.hashCode();
        result += this.eagerLoadGroup == null ? 0 : this.eagerLoadGroup.hashCode();
        return result += this.leftJoinList == null ? 0 : ((Object)this.leftJoinList).hashCode();
    }

    public String toString() {
        return "[cmr-field=" + this.cmrField + ", eager-load-group=" + this.eagerLoadGroup + ", left-join=" + this.leftJoinList + ']';
    }
}

