/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.ejbql;

import org.jboss.ejb.plugins.cmp.ejbql.JBossQLParserVisitor;
import org.jboss.ejb.plugins.cmp.ejbql.SimpleNode;

public final class ASTExactNumericLiteral
extends SimpleNode {
    public long value;
    public String literal;
    private static final String LOFFER_L = "l";
    private static final String UPPER_L = "L";
    private static final String OX = "0X";
    private static final String Ox = "0x";
    private static final String ZERRO = "0";

    public ASTExactNumericLiteral(int id) {
        super(id);
    }

    public void setValue(String number) {
        this.literal = number;
        if (number.endsWith(LOFFER_L) || number.endsWith(UPPER_L)) {
            number = number.substring(0, number.length() - 1);
        }
        if (number.startsWith(OX) || number.startsWith(Ox)) {
            byte first;
            if (number.length() == 18 && (first = Byte.decode(number.substring(0, 3)).byteValue()) >= 8) {
                number = Ox + (first - 8) + number.substring(3);
                this.value = Long.decode(number) - Long.MAX_VALUE - 1L;
                return;
            }
        } else if (number.startsWith(ZERRO) && number.length() == 23 && number.charAt(1) == '1') {
            number = ZERRO + number.substring(2);
            this.value = Long.decode(number) - Long.MAX_VALUE - 1L;
            return;
        }
        this.value = Long.decode(number);
    }

    public String toString() {
        return this.literal;
    }

    public Object jjtAccept(JBossQLParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}

