/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.LinkedList;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.plugins.AbstractInstancePoolMBean;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;

public abstract class AbstractInstancePool
extends ServiceMBeanSupport
implements AbstractInstancePoolMBean,
InstancePool,
XmlLoadable {
    private FIFOSemaphore strictMaxSize;
    private long strictTimeout = Long.MAX_VALUE;
    protected Container container;
    protected LinkedList pool = new LinkedList();
    protected int maxSize = 30;
    protected boolean reclaim = false;
    protected Boolean isStrict = Boolean.FALSE;

    public void setContainer(Container c) {
        this.container = c;
    }

    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSize() {
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            return this.pool.size();
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getAvailableCount() {
        long size = Long.MAX_VALUE;
        if (this.strictMaxSize != null) {
            size = this.strictMaxSize.permits();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseContext get() throws Exception {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Get instance " + this + "#" + this.pool.size() + "#" + this.getContainer().getBeanClass()));
        }
        if (this.strictMaxSize != null) {
            boolean acquired = this.strictMaxSize.attempt(this.strictTimeout);
            if (trace) {
                this.log.trace((Object)("Acquired(" + acquired + ") strictMaxSize semaphore, remaining=" + this.strictMaxSize.permits()));
            }
            if (!acquired) {
                throw new EJBException("Failed to acquire the pool semaphore, strictTimeout=" + this.strictTimeout);
            }
        }
        LinkedList acquired = this.pool;
        synchronized (acquired) {
            if (!this.pool.isEmpty()) {
                return (EnterpriseContext)this.pool.removeFirst();
            }
        }
        try {
            Object instance = this.container.createBeanClassInstance();
            return this.create(instance);
        }
        catch (Throwable e) {
            if (this.strictMaxSize != null) {
                this.strictMaxSize.release();
            }
            if (e instanceof CreateException) {
                throw (CreateException)e;
            }
            Exception ex = null;
            ex = e instanceof Exception ? (Exception)e : new UndeclaredThrowableException(e);
            throw new EJBException("Could not instantiate bean", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(EnterpriseContext ctx) {
        if (this.log.isTraceEnabled()) {
            String msg = this.pool.size() + "/" + this.maxSize + " Free instance:" + this + "#" + ctx.getId() + "#" + ctx.getTransaction() + "#" + this.reclaim + "#" + this.getContainer().getBeanClass();
            this.log.trace((Object)msg);
        }
        ctx.clear();
        try {
            boolean addedToPool = false;
            LinkedList linkedList = this.pool;
            synchronized (linkedList) {
                if (this.pool.size() < this.maxSize) {
                    this.pool.addFirst(ctx);
                    addedToPool = true;
                }
            }
            if (addedToPool) {
                if (this.strictMaxSize != null) {
                    this.strictMaxSize.release();
                }
            } else {
                this.discard(ctx);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void discard(EnterpriseContext ctx) {
        block4: {
            if (this.log.isTraceEnabled()) {
                String msg = "Discard instance:" + this + "#" + ctx + "#" + ctx.getTransaction() + "#" + this.reclaim + "#" + this.getContainer().getBeanClass();
                this.log.trace((Object)msg);
            }
            if (this.strictMaxSize != null) {
                this.strictMaxSize.release();
            }
            try {
                ctx.discard();
            }
            catch (RemoteException e) {
                if (!this.log.isTraceEnabled()) break block4;
                this.log.trace((Object)"Ctx.discard error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            this.freeAll();
        }
    }

    public void importXml(Element element) throws DeploymentException {
        String maximumSize = MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)element, (String)"MaximumSize"));
        try {
            this.maxSize = Integer.parseInt(maximumSize);
        }
        catch (NumberFormatException e) {
            throw new DeploymentException("Invalid MaximumSize value for instance pool configuration");
        }
        String strictValue = MetaData.getElementContent((Element)MetaData.getOptionalChild((Element)element, (String)"strictMaximumSize"));
        this.isStrict = Boolean.valueOf(strictValue);
        String delay = MetaData.getElementContent((Element)MetaData.getOptionalChild((Element)element, (String)"strictTimeout"));
        try {
            if (delay != null) {
                this.strictTimeout = Long.parseLong(delay);
            }
        }
        catch (NumberFormatException e) {
            throw new DeploymentException("Invalid strictTimeout value for instance pool configuration");
        }
    }

    protected abstract EnterpriseContext create(Object var1) throws Exception;

    protected void createService() throws Exception {
        if (this.isStrict == Boolean.TRUE) {
            this.strictMaxSize = new FIFOSemaphore((long)this.maxSize);
        }
    }

    protected void destroyService() throws Exception {
        this.freeAll();
        this.strictMaxSize = null;
    }

    private void freeAll() {
        LinkedList clone = (LinkedList)this.pool.clone();
        for (int i = 0; i < clone.size(); ++i) {
            EnterpriseContext ec = (EnterpriseContext)clone.get(i);
            ec.clear();
            this.discard(ec);
        }
        this.pool.clear();
    }
}

