/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.kernel.Kernel;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;
import org.jboss.scanning.plugins.visitor.CachingReflectProvider;
import org.jboss.scanning.plugins.visitor.ConfiguratorReflectProvider;
import org.jboss.scanning.plugins.visitor.ErrorHandler;
import org.jboss.scanning.plugins.visitor.ReflectProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtilSetupDeployer
extends AbstractSimpleRealDeployer<Module> {
    private ReflectProvider provider;
    private ErrorHandler handler;
    private ResourceOwnerFinder finder;

    public ResourceUtilSetupDeployer(Kernel kernel) {
        super(Module.class);
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel");
        }
        this.setStage(DeploymentStages.CLASSLOADER);
        this.provider = new ConfiguratorReflectProvider(kernel.getConfigurator());
    }

    public void deploy(DeploymentUnit unit, Module deployment) throws DeploymentException {
        unit.addAttachment(ReflectProvider.class, (Object)new CachingReflectProvider(this.provider));
        if (this.handler != null) {
            unit.addAttachment(ErrorHandler.class, (Object)this.handler);
        }
        if (this.finder != null) {
            unit.addAttachment(ResourceOwnerFinder.class, (Object)this.finder);
        }
    }

    public void undeploy(DeploymentUnit unit, Module deployment) {
        if (this.handler != null) {
            unit.removeAttachment(ErrorHandler.class);
        }
        if (this.finder != null) {
            unit.removeAttachment(ResourceOwnerFinder.class);
        }
        unit.removeAttachment(ReflectProvider.class);
    }

    public void setHandler(ErrorHandler handler) {
        this.handler = handler;
    }

    public void setFinder(ResourceOwnerFinder finder) {
        this.finder = finder;
    }
}

