/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.TypedCollections;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    private static final FactoryManagerCache FACTORIES_CACHE = new FactoryManagerCache();
    private static final String[] FACTORY_NAMES = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.context.FacesContextFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory"};
    private static Map<String, Class> factoryClasses = null;
    private static final Logger LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");

    FactoryFinder() {
    }

    public static Object getFactory(String factoryName) throws FacesException {
        FactoryFinder.validateFactoryName(factoryName);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        FactoryManager manager = FactoryFinder.FACTORIES_CACHE.getApplicationFactoryManager(classLoader);
        return manager.getFactory(classLoader, factoryName);
    }

    public static void setFactory(String factoryName, String implName) {
        FactoryFinder.validateFactoryName(factoryName);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        FactoryManager manager = FactoryFinder.FACTORIES_CACHE.getApplicationFactoryManager(classLoader);
        manager.addFactory(factoryName, implName);
    }

    public static void releaseFactories() throws FacesException {
        ClassLoader cl = FactoryFinder.getClassLoader();
        FACTORIES_CACHE.removeApplicationFactoryManager(cl);
    }

    private static ClassLoader getClassLoader() throws FacesException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            throw new FacesException("getContextClassLoader");
        }
        return cl;
    }

    private static Object getImplementationInstance(ClassLoader classLoader, String factoryName, List implementations) throws FacesException {
        List<String> fromServices;
        String curImplClass;
        int len;
        Object result = null;
        if (null != implementations && (1 < (len = implementations.size()) || 1 == len)) {
            curImplClass = (String)implementations.remove(len - 1);
            result = FactoryFinder.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, null);
        }
        if ((fromServices = FactoryFinder.getImplNameFromServices(classLoader, factoryName)) != null) {
            for (String name : fromServices) {
                result = FactoryFinder.getImplGivenPreviousImpl(classLoader, factoryName, name, result);
            }
        }
        if (null != implementations) {
            for (len = implementations.size() - 1; 0 <= len; --len) {
                curImplClass = (String)implementations.remove(len);
                result = FactoryFinder.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getImplNameFromServices(ClassLoader classLoader, String factoryName) {
        ArrayList<String> result;
        block12: {
            result = null;
            String resourceName = "META-INF/services/" + factoryName;
            BufferedReader reader = null;
            try {
                Enumeration<URL> e = classLoader.getResources(resourceName);
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    InputStream stream = conn.getInputStream();
                    if (stream == null) continue;
                    try {
                        reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                        if (result == null) {
                            result = new ArrayList<String>(3);
                        }
                        result.add(reader.readLine());
                    }
                    catch (UnsupportedEncodingException uee) {
                        reader = new BufferedReader(new InputStreamReader(stream));
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                            reader = null;
                        }
                        if (stream == null) continue;
                        stream.close();
                        stream = null;
                    }
                }
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
            catch (SecurityException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block12;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        return result;
    }

    private static Object getImplGivenPreviousImpl(ClassLoader classLoader, String factoryName, String implName, Object previousImpl) {
        Class<?> clazz;
        Class factoryClass = null;
        Object[] newInstanceArgs = new Object[1];
        Object result = null;
        if (null != previousImpl && null != (factoryClass = FactoryFinder.getFactoryClass(factoryName))) {
            try {
                clazz = Class.forName(implName, false, classLoader);
                Class[] getCtorArg = new Class[]{factoryClass};
                Constructor<?> ctor = clazz.getConstructor(getCtorArg);
                newInstanceArgs[0] = previousImpl;
                result = ctor.newInstance(newInstanceArgs);
            }
            catch (NoSuchMethodException nsme) {
                factoryClass = null;
            }
            catch (Exception e) {
                throw new FacesException(implName, e);
            }
        }
        if (null == previousImpl || null == factoryClass) {
            try {
                clazz = Class.forName(implName, false, classLoader);
                result = clazz.newInstance();
            }
            catch (Exception e) {
                throw new FacesException(implName, e);
            }
        }
        return result;
    }

    private static Class getFactoryClass(String factoryClassName) {
        if (null == factoryClasses) {
            factoryClasses = new HashMap<String, Class>(FACTORY_NAMES.length);
            factoryClasses.put(APPLICATION_FACTORY, ApplicationFactory.class);
            factoryClasses.put(FACES_CONTEXT_FACTORY, FacesContextFactory.class);
            factoryClasses.put(LIFECYCLE_FACTORY, LifecycleFactory.class);
            factoryClasses.put(RENDER_KIT_FACTORY, RenderKitFactory.class);
        }
        return factoryClasses.get(factoryClassName);
    }

    private static void validateFactoryName(String factoryName) {
        if (factoryName == null) {
            throw new NullPointerException();
        }
        if (Arrays.binarySearch(FACTORY_NAMES, factoryName) < 0) {
            throw new IllegalArgumentException(factoryName);
        }
    }

    private static final class FactoryManager {
        private final Map<String, Object> factories = new HashMap<String, Object>();
        private final ReentrantReadWriteLock lock;

        public FactoryManager() {
            for (String name : FACTORY_NAMES) {
                this.factories.put(name, new ArrayList(4));
            }
            this.lock = new ReentrantReadWriteLock(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFactory(String factoryName, String implementation) {
            Object result = this.factories.get(factoryName);
            this.lock.writeLock().lock();
            try {
                if (result instanceof List) {
                    TypedCollections.dynamicallyCastList((List)result, String.class).add(0, implementation);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getFactory(ClassLoader cl, String factoryName) {
            Object factoryOrList;
            this.lock.readLock().lock();
            try {
                factoryOrList = this.factories.get(factoryName);
                if (!(factoryOrList instanceof List)) {
                    Object object = factoryOrList;
                    return object;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            this.lock.writeLock().lock();
            try {
                factoryOrList = this.factories.get(factoryName);
                if (!(factoryOrList instanceof List)) {
                    Object object = factoryOrList;
                    return object;
                }
                Object factory = FactoryFinder.getImplementationInstance(cl, factoryName, (List)factoryOrList);
                if (factory == null) {
                    ResourceBundle rb = LOGGER.getResourceBundle();
                    String message = rb.getString("severe.no_factory");
                    message = MessageFormat.format(message, factoryName);
                    throw new IllegalStateException(message);
                }
                this.factories.put(factoryName, factory);
                Object object = factory;
                return object;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private static final class FactoryManagerCache {
        private ConcurrentMap<ClassLoader, Future<FactoryManager>> applicationMap = new ConcurrentHashMap<ClassLoader, Future<FactoryManager>>();

        private FactoryManagerCache() {
        }

        /*
         * Loose catch block
         */
        private FactoryManager getApplicationFactoryManager(ClassLoader cl) {
            while (true) {
                Callable<FactoryManager> callable;
                FutureTask<FactoryManager> ft;
                FutureTask<FactoryManager> factories;
                if ((factories = (FutureTask<FactoryManager>)this.applicationMap.get(cl)) == null && (factories = (Future)this.applicationMap.putIfAbsent(cl, ft = new FutureTask<FactoryManager>(callable = new Callable<FactoryManager>(){

                    @Override
                    public FactoryManager call() throws Exception {
                        return new FactoryManager();
                    }
                }))) == null) {
                    factories = ft;
                    ft.run();
                }
                try {
                    return (FactoryManager)factories.get();
                }
                catch (CancellationException ce) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, ce.toString(), ce);
                    }
                    this.applicationMap.remove(cl);
                    continue;
                }
                catch (InterruptedException ie) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, ie.toString(), ie);
                    }
                    this.applicationMap.remove(cl);
                    continue;
                }
                break;
            }
            catch (ExecutionException ee) {
                throw new FacesException(ee);
            }
        }

        public void removeApplicationFactoryManager(ClassLoader cl) {
            this.applicationMap.remove(cl);
        }
    }
}

