/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Date;
import org.apache.juddi.datatype.BindingKey;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.subscription.Subscription;
import org.apache.juddi.datatype.subscription.SubscriptionFilter;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class SubscriptionHandler
extends AbstractHandler {
    public static final String TAG_NAME = "subscription";
    private HandlerMaker maker = null;

    protected SubscriptionHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        Subscription obj = new Subscription();
        Object nodeList = null;
        Object handler = null;
        obj.setSubscriptionKey(element.getAttribute("subscriptionKey"));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Subscription subscription = (Subscription)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        Object handler = null;
        String subscriptionKey = subscription.getSubscriptionKey();
        if (subscriptionKey != null) {
            element.setAttribute("subscriptionKey", subscriptionKey);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        Subscription subscription = new Subscription();
        subscription.setSubscriptionKey("uuid:269855db-62eb-4862-8e5a-1b06f2753038");
        subscription.setBindingKey(new BindingKey(""));
        subscription.setBrief(true);
        subscription.setExpiresAfter(new Date());
        subscription.setMaxEntities(100);
        subscription.setNotificationInterval("");
        subscription.setSubscriptionFilter(new SubscriptionFilter());
        System.out.println();
        RegistryObject regObject = subscription;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

