/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.binding.InstanceDetails;
import org.apache.juddi.datatype.binding.InstanceParms;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;

class TModelInstanceInfoTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$TModelInstanceInfoTable == null ? (class$org$apache$juddi$datastore$jdbc$TModelInstanceInfoTable = TModelInstanceInfoTable.class$("org.apache.juddi.datastore.jdbc.TModelInstanceInfoTable")) : class$org$apache$juddi$datastore$jdbc$TModelInstanceInfoTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$TModelInstanceInfoTable;

    TModelInstanceInfoTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String bindingKey, Vector infoList, Connection connection) throws SQLException {
        if (infoList == null || infoList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, bindingKey.toString());
            int listSize = infoList.size();
            for (int infoID = 0; infoID < listSize; ++infoID) {
                InstanceDetails details;
                String tModelKey = null;
                String overURL = null;
                String instParms = null;
                TModelInstanceInfo info = (TModelInstanceInfo)infoList.elementAt(infoID);
                if (info.getTModelKey() != null) {
                    tModelKey = info.getTModelKey().toString();
                }
                if ((details = info.getInstanceDetails()) != null) {
                    if (details.getOverviewDoc() != null) {
                        overURL = details.getOverviewDoc().getOverviewURLString();
                    }
                    if (details.getInstanceParms() != null) {
                        instParms = details.getInstanceParms().getValue();
                    }
                }
                statement.setInt(2, infoID);
                statement.setString(3, tModelKey);
                statement.setString(4, overURL);
                statement.setString(5, instParms);
                log.debug((Object)("insert into TMODEL_INSTANCE_INFO table:\n\n\t" + insertSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n\t TMODEL_INSTANCE_INFO_ID=" + infoID + "\n\t TMODEL_KEY=" + tModelKey + "\n\t OVERVIEW_URL=" + overURL + "\n\t INSTANCE_PARMS=" + instParms + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String bindingKey, Connection connection) throws SQLException {
        Vector<TModelInstanceInfo> infoList = new Vector<TModelInstanceInfo>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, bindingKey.toString());
            log.debug((Object)("select from TMODEL_INSTANCE_INFO table:\n\n\t" + selectSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String tModelKey = resultSet.getString(1);
                String overURL = resultSet.getString(2);
                String instParms = resultSet.getString(3);
                if (tModelKey == null) continue;
                TModelInstanceInfo info = new TModelInstanceInfo();
                info.setTModelKey(tModelKey);
                OverviewDoc overviewDoc = null;
                if (overURL != null) {
                    overviewDoc = new OverviewDoc();
                    overviewDoc.setOverviewURL(overURL);
                }
                InstanceParms instanceParms = null;
                if (instParms != null) {
                    instanceParms = new InstanceParms();
                    instanceParms.setText(instParms);
                }
                InstanceDetails details = null;
                if (overviewDoc != null || instanceParms != null) {
                    details = new InstanceDetails();
                    details.setOverviewDoc(overviewDoc);
                    details.setInstanceParms(instanceParms);
                    info.setInstanceDetails(details);
                }
                infoList.add(info);
            }
            Vector<TModelInstanceInfo> vector = infoList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String bindingKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, bindingKey.toString());
            log.debug((Object)("delete from TMODEL_INSTANCE_INFO table:\n\n\t" + deleteSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO TMODEL_INSTANCE_INFO (");
        sql.append("BINDING_KEY,");
        sql.append("TMODEL_INSTANCE_INFO_ID,");
        sql.append("TMODEL_KEY, ");
        sql.append("OVERVIEW_URL,");
        sql.append("INSTANCE_PARMS) ");
        sql.append("VALUES (?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("TMODEL_KEY,");
        sql.append("OVERVIEW_URL,");
        sql.append("INSTANCE_PARMS, ");
        sql.append("TMODEL_INSTANCE_INFO_ID ");
        sql.append("FROM TMODEL_INSTANCE_INFO ");
        sql.append("WHERE BINDING_KEY=? ");
        sql.append("ORDER BY TMODEL_INSTANCE_INFO_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM TMODEL_INSTANCE_INFO ");
        sql.append("WHERE BINDING_KEY=?");
        deleteSQL = sql.toString();
    }
}

