/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.deployers;

import java.util.List;
import java.util.ListIterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.management.j2ee.MBean;
import org.jboss.management.j2ee.ServiceModule;
import org.jboss.management.j2ee.deployers.AbstractVFSJSR77Deployer;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceModuleJSR77Deployer
extends AbstractVFSJSR77Deployer<ServiceDeployment> {
    public ServiceModuleJSR77Deployer() {
        super(ServiceDeployment.class);
    }

    @Override
    protected void deployJsr77(MBeanServer server, VFSDeploymentUnit unit, ServiceDeployment metaData) throws Throwable {
        ObjectName sarName = ServiceModule.create(server, unit.getSimpleName(), unit.getRoot().toURL());
        if (sarName != null) {
            this.log.debug((Object)("Created ServiceModule: " + sarName));
            List beans = metaData.getServices();
            if (beans != null && !beans.isEmpty()) {
                for (ServiceMetaData bean : beans) {
                    ObjectName mbeanName = bean.getObjectName();
                    MBean.create(server, sarName.toString(), mbeanName);
                    this.log.debug((Object)("Create MBean, name: " + mbeanName + ", SAR Module: " + sarName));
                }
            }
        }
    }

    @Override
    protected void undeployJsr77(MBeanServer server, VFSDeploymentUnit unit, ServiceDeployment metaData) {
        List beans = metaData.getServices();
        if (beans != null && !beans.isEmpty()) {
            ListIterator iter = beans.listIterator(beans.size());
            while (iter.hasPrevious()) {
                ObjectName name = ((ServiceMetaData)iter.previous()).getObjectName();
                try {
                    MBean.destroy(server, name.toString());
                    this.log.debug((Object)("Destroy MBean, name: " + name));
                }
                catch (Throwable e) {
                    this.log.debug((Object)"Failed to remove remove JSR-77 MBean", e);
                }
            }
        }
        String moduleName = unit.getSimpleName();
        try {
            ServiceModule.destroy(server, moduleName);
            this.log.debug((Object)("Removed JSR-77 SAR: " + moduleName));
        }
        catch (Throwable e) {
            this.log.debug((Object)("Failed to remove JSR-77 SAR: " + moduleName));
        }
    }
}

