/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.context.flash;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.event.PhaseId;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.shared_impl.context.flash.SubKeyMap;
import org.apache.myfaces.shared_impl.util.ExternalContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashImpl
extends Flash {
    protected static final String FLASH_INSTANCE = FlashImpl.class.getName() + ".INSTANCE";
    protected static final String FLASH_REDIRECT = FlashImpl.class.getName() + ".REDIRECT";
    protected static final String FLASH_KEEP_MESSAGES = FlashImpl.class.getName() + ".KEEP_MESSAGES";
    protected static final String FLASH_KEEP_MESSAGES_LIST = "KEEPMESSAGESLIST";
    protected static final String FLASH_SCOPE_CACHE = FlashImpl.class.getName() + ".SCOPE";
    protected static final String FLASH_CURRENT_MAP_CACHE = FlashImpl.class.getName() + ".CURRENTMAP.CACHE";
    protected static final String FLASH_CURRENT_MAP_KEY = FlashImpl.class.getName() + ".CURRENTMAP.KEY";
    protected static final String FLASH_POSTBACK_MAP_CACHE = FlashImpl.class.getName() + ".POSTBACKMAP.CACHE";
    protected static final String FLASH_POSTBACK_MAP_KEY = FlashImpl.class.getName() + ".POSTBACKMAP.KEY";
    private static final char SEPARATOR_CHAR = '.';
    private final AtomicLong _count = new AtomicLong(FlashImpl._getSeed());

    private static long _getSeed() {
        SecureRandom rng;
        try {
            rng = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            rng = new SecureRandom();
        }
        byte[] randomBytes = new byte[6];
        rng.nextBytes(randomBytes);
        return new BigInteger(randomBytes).longValue();
    }

    protected String _getNextToken() {
        long nextToken = this._count.incrementAndGet();
        return Long.toString(nextToken, 36);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Flash getCurrentInstance(ExternalContext context) {
        Map applicationMap = context.getApplicationMap();
        Flash flash = (Flash)applicationMap.get(FLASH_INSTANCE);
        Map map = applicationMap;
        synchronized (map) {
            if (flash == null) {
                flash = new FlashImpl();
                context.getApplicationMap().put(FLASH_INSTANCE, flash);
            }
        }
        return flash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> _getMapFromSession(FacesContext context, String token, boolean createIfNeeded) {
        ExternalContext external = context.getExternalContext();
        Object session = external.getSession(createIfNeeded);
        if (session == null) {
            return null;
        }
        SubKeyMap map = null;
        Object object = session;
        synchronized (object) {
            map = (SubKeyMap)external.getSessionMap().get(token);
            if (map == null && createIfNeeded) {
                map = new SubKeyMap(context.getExternalContext().getSessionMap(), token);
            }
        }
        return map;
    }

    protected Map<String, Object> getCurrentRequestMap(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Map<String, Object> map = (Map<String, Object>)requestMap.get(FLASH_CURRENT_MAP_CACHE);
        if (map == null) {
            String token = (String)requestMap.get(FLASH_CURRENT_MAP_KEY);
            String fullToken = FLASH_SCOPE_CACHE + '.' + token;
            map = this._getMapFromSession(context, fullToken, true);
            requestMap.put(FLASH_CURRENT_MAP_CACHE, map);
        }
        return map;
    }

    protected Map<String, Object> getPostbackRequestMap(FacesContext context) {
        return this._getPostbackRequestMap(context, true);
    }

    private Map<String, Object> _getPostbackRequestMap(FacesContext context, boolean createIfNeeded) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Map<String, Object> map = (Map<String, Object>)requestMap.get(FLASH_POSTBACK_MAP_CACHE);
        if (map == null) {
            String token = (String)requestMap.get(FLASH_POSTBACK_MAP_KEY);
            if (token == null && this.isRedirect()) {
                token = this._getPostbackMapKey(context.getExternalContext());
            }
            String fullToken = FLASH_SCOPE_CACHE + '.' + token;
            map = this._getMapFromSession(context, fullToken, createIfNeeded);
            requestMap.put(FLASH_POSTBACK_MAP_CACHE, map);
        }
        return map;
    }

    private Map<String, Object> getCurrentPhaseMap() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (PhaseId.RENDER_RESPONSE.equals(facesContext.getCurrentPhaseId()) || !facesContext.isPostback() || this.isRedirect()) {
            return this.getCurrentRequestMap(facesContext);
        }
        return this.getPostbackRequestMap(facesContext);
    }

    private void _removeAllChildren(FacesContext facesContext) {
        Map<String, Object> map = this._getPostbackRequestMap(facesContext, false);
        if (map != null) {
            map.clear();
        }
    }

    public void doPrePhaseActions(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        if (PhaseId.RESTORE_VIEW.equals(facesContext.getCurrentPhaseId())) {
            String currentToken = this._getNextToken();
            requestMap.put(FLASH_CURRENT_MAP_KEY, currentToken);
            String previousToken = this._getPostbackMapKey(facesContext.getExternalContext());
            if (previousToken != null) {
                requestMap.put(FLASH_POSTBACK_MAP_KEY, previousToken);
            }
            if (this.isKeepMessages()) {
                this.restoreMessages(facesContext);
            }
        }
        if (PhaseId.RENDER_RESPONSE.equals(facesContext.getCurrentPhaseId()) && !this.isRedirect()) {
            this._addPostbackMapKey(facesContext.getExternalContext());
        }
    }

    public void doPostPhaseActions(FacesContext facesContext) {
        if (PhaseId.RENDER_RESPONSE.equals(facesContext.getCurrentPhaseId())) {
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            String token = (String)requestMap.get(FLASH_POSTBACK_MAP_KEY);
            if (token != null) {
                this._removeAllChildren(facesContext);
            }
            if (this.isKeepMessages()) {
                this.saveMessages(facesContext);
            }
        } else if (this.isRedirect() && (facesContext.getResponseComplete() || facesContext.getRenderResponse()) && this.isKeepMessages()) {
            this.saveMessages(facesContext);
        }
    }

    protected void saveMessages(FacesContext facesContext) {
        ArrayList<MessageEntry> messageList = null;
        Iterator iterClientIds = facesContext.getClientIdsWithMessages();
        while (iterClientIds.hasNext()) {
            String clientId = (String)iterClientIds.next();
            Iterator iterMessages = facesContext.getMessages(clientId);
            while (iterMessages.hasNext()) {
                FacesMessage message = (FacesMessage)iterMessages.next();
                if (messageList == null) {
                    messageList = new ArrayList<MessageEntry>();
                }
                messageList.add(new MessageEntry(clientId, message));
            }
        }
        if (messageList != null) {
            if (this.isRedirect()) {
                this.getPostbackRequestMap(facesContext).put(FLASH_KEEP_MESSAGES_LIST, messageList);
            } else {
                this.getCurrentRequestMap(facesContext).put(FLASH_KEEP_MESSAGES_LIST, messageList);
            }
        }
    }

    protected void restoreMessages(FacesContext facesContext) {
        Map<String, Object> postbackMap = this.getPostbackRequestMap(facesContext);
        List messageList = (List)postbackMap.get(FLASH_KEEP_MESSAGES_LIST);
        if (messageList != null) {
            for (MessageEntry message : messageList) {
                facesContext.addMessage((String)message.clientId, (FacesMessage)message.message);
            }
            postbackMap.remove(FLASH_KEEP_MESSAGES_LIST);
        }
    }

    private String _getPostbackMapKey(ExternalContext externalContext) {
        String token = null;
        HttpServletResponse httpResponse = ExternalContextUtils.getHttpServletResponse(externalContext);
        if (httpResponse != null) {
            Cookie cookie = (Cookie)externalContext.getRequestCookieMap().get(FLASH_POSTBACK_MAP_KEY);
            if (cookie != null) {
                token = cookie.getValue();
            }
        } else {
            Map sessionMap = externalContext.getSessionMap();
            token = (String)sessionMap.get(FLASH_POSTBACK_MAP_KEY);
        }
        return token;
    }

    private void _addPostbackMapKey(ExternalContext externalContext) {
        String token = (String)externalContext.getRequestMap().get(FLASH_CURRENT_MAP_KEY);
        HttpServletResponse httpResponse = ExternalContextUtils.getHttpServletResponse(externalContext);
        if (httpResponse != null) {
            Cookie cookie = new Cookie(FLASH_POSTBACK_MAP_KEY, token);
            cookie.setMaxAge(-1);
            httpResponse.addCookie(cookie);
        } else {
            Map sessionMap = externalContext.getSessionMap();
            sessionMap.put(FLASH_POSTBACK_MAP_KEY, token);
        }
    }

    public boolean isRedirect() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Boolean redirect = (Boolean)requestMap.get(FLASH_REDIRECT);
        if (redirect == null) {
            HttpServletResponse httpResponse = ExternalContextUtils.getHttpServletResponse(externalContext);
            if (httpResponse != null) {
                Cookie cookie = (Cookie)externalContext.getRequestCookieMap().get(FLASH_REDIRECT);
                if (cookie != null) {
                    redirect = Boolean.TRUE;
                    cookie.setMaxAge(0);
                    cookie.setValue(null);
                    httpResponse.addCookie(cookie);
                    requestMap.put(FLASH_REDIRECT, redirect);
                } else {
                    redirect = Boolean.FALSE;
                }
            } else {
                Map sessionMap = externalContext.getSessionMap();
                redirect = (Boolean)sessionMap.get(FLASH_REDIRECT);
                if (redirect != null) {
                    sessionMap.remove(FLASH_REDIRECT);
                    requestMap.put(FLASH_REDIRECT, redirect);
                } else {
                    redirect = Boolean.FALSE;
                }
            }
        }
        return redirect;
    }

    public void setRedirect(boolean redirect) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Boolean previousRedirect = (Boolean)requestMap.get(FLASH_REDIRECT);
        Boolean bl = previousRedirect = previousRedirect == null ? Boolean.FALSE : previousRedirect;
        if (!previousRedirect.booleanValue() && redirect) {
            Object response = externalContext.getResponse();
            if (response instanceof HttpServletResponse) {
                HttpServletResponse servletResponse = (HttpServletResponse)response;
                Cookie cookie = new Cookie(FLASH_REDIRECT, "true");
                cookie.setMaxAge(-1);
                servletResponse.addCookie(cookie);
            } else {
                externalContext.getSessionMap().put(FLASH_REDIRECT, redirect);
            }
        }
        requestMap.put(FLASH_REDIRECT, redirect);
    }

    public void keep(String key) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Object value = requestMap.get(key);
        this.getCurrentRequestMap(facesContext).put(key, value);
    }

    public void putNow(String key, Object value) {
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(key, value);
    }

    public boolean isKeepMessages() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Boolean keepMessages = (Boolean)requestMap.get(FLASH_KEEP_MESSAGES);
        if (keepMessages == null) {
            HttpServletResponse httpResponse = ExternalContextUtils.getHttpServletResponse(externalContext);
            if (httpResponse != null) {
                Cookie cookie = (Cookie)externalContext.getRequestCookieMap().get(FLASH_KEEP_MESSAGES);
                if (cookie != null) {
                    keepMessages = Boolean.TRUE;
                    cookie.setMaxAge(0);
                    cookie.setValue(null);
                    httpResponse.addCookie(cookie);
                    requestMap.put(FLASH_KEEP_MESSAGES, keepMessages);
                } else {
                    keepMessages = Boolean.FALSE;
                }
            } else {
                Map sessionMap = externalContext.getSessionMap();
                keepMessages = (Boolean)sessionMap.get(FLASH_KEEP_MESSAGES);
                if (keepMessages != null) {
                    sessionMap.remove(FLASH_KEEP_MESSAGES);
                    requestMap.put(FLASH_KEEP_MESSAGES, keepMessages);
                } else {
                    keepMessages = Boolean.FALSE;
                }
            }
        }
        return keepMessages;
    }

    public void setKeepMessages(boolean keepMessages) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Boolean previousKeepMessages = (Boolean)requestMap.get(FLASH_KEEP_MESSAGES);
        Boolean bl = previousKeepMessages = previousKeepMessages == null ? Boolean.FALSE : previousKeepMessages;
        if (!previousKeepMessages.booleanValue() && keepMessages) {
            Object response = externalContext.getResponse();
            if (response instanceof HttpServletResponse) {
                HttpServletResponse servletResponse = (HttpServletResponse)response;
                Cookie cookie = new Cookie(FLASH_KEEP_MESSAGES, "true");
                cookie.setMaxAge(-1);
                servletResponse.addCookie(cookie);
            } else {
                externalContext.getSessionMap().put(FLASH_KEEP_MESSAGES, keepMessages);
            }
        }
        requestMap.put(FLASH_KEEP_MESSAGES, keepMessages);
    }

    public void clear() {
        this.getCurrentPhaseMap().clear();
    }

    public boolean containsKey(Object key) {
        return this.getCurrentPhaseMap().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.getCurrentPhaseMap().containsValue(value);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.getCurrentPhaseMap().entrySet();
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        if ("keepMessages".equals(key)) {
            return this.isKeepMessages();
        }
        if ("redirect".equals(key)) {
            return this.isRedirect();
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Map<String, Object> postbackMap = this.getPostbackRequestMap(context);
        Object returnValue = null;
        if (postbackMap != null) {
            returnValue = postbackMap.get(key);
        }
        return returnValue;
    }

    public boolean isEmpty() {
        return this.getCurrentPhaseMap().isEmpty();
    }

    public Set<String> keySet() {
        return this.getCurrentPhaseMap().keySet();
    }

    public Object put(String key, Object value) {
        if (key == null) {
            return null;
        }
        if ("keepMessages".equals(key)) {
            Boolean booleanValue = this.convertToBoolean(value);
            this.setKeepMessages(booleanValue);
            return booleanValue;
        }
        if ("redirect".equals(key)) {
            Boolean booleanValue = this.convertToBoolean(value);
            this.setRedirect(booleanValue);
            return booleanValue;
        }
        Object returnValue = this.getCurrentPhaseMap().put(key, value);
        return returnValue;
    }

    private Boolean convertToBoolean(Object value) {
        Boolean booleanValue = value instanceof Boolean ? (Boolean)value : Boolean.valueOf(Boolean.parseBoolean(value.toString()));
        return booleanValue;
    }

    public void putAll(Map<? extends String, ? extends Object> m) {
        this.getCurrentPhaseMap().putAll(m);
    }

    public Object remove(Object key) {
        return this.getCurrentPhaseMap().remove(key);
    }

    public int size() {
        return this.getCurrentPhaseMap().size();
    }

    public Collection<Object> values() {
        return this.getCurrentPhaseMap().values();
    }

    private static class MessageEntry
    implements Serializable {
        private static final long serialVersionUID = -690264660230199234L;
        private final Object clientId;
        private final Object message;

        public MessageEntry(Object clientId, Object message) {
            this.clientId = clientId;
            this.message = message;
        }
    }
}

