/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.HashMap;
import java.util.Map;
import org.jboss.kernel.api.dependency.Matcher;
import org.jboss.kernel.api.dependency.MatcherFactory;
import org.jboss.kernel.api.dependency.MatcherTransformer;
import org.jboss.kernel.plugins.dependency.DefaultMatcher;
import org.jboss.kernel.plugins.dependency.IntervalMatcherTransformer;
import org.jboss.kernel.plugins.dependency.RegexpMatcherTransformer;
import org.jboss.logging.Logger;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;

public class DefaultMatcherFactory
extends MatcherFactory
implements MatcherTransformer {
    protected Logger log = Logger.getLogger(this.getClass());
    private Map<String, MatcherTransformer> transfomers = new HashMap<String, MatcherTransformer>();

    public DefaultMatcherFactory() {
        this.addMatcherTransfomer("default", this);
        this.addMatcherTransfomer("regexp", new RegexpMatcherTransformer());
        this.addMatcherTransfomer("interval", new IntervalMatcherTransformer());
    }

    public void addMatcherTransfomer(String key, MatcherTransformer transformer) {
        if (key == null && transformer != null) {
            this.transfomers.put(transformer.getClass().getName(), transformer);
        }
        if (key != null) {
            if (transformer == null) {
                this.transfomers.remove(key);
            } else {
                this.transfomers.put(key, transformer);
            }
        }
    }

    public Matcher createMatcher(String transformer, Object value) {
        MatcherTransformer mt;
        if (value instanceof Matcher) {
            return (Matcher)value;
        }
        if (transformer == null) {
            transformer = "default";
        }
        if ((mt = this.transfomers.get(transformer)) != null) {
            return mt.transform(value);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("No matching transfomer key '" + transformer + "', trying to instantiate new."));
        }
        try {
            mt = (MatcherTransformer)ReflectionUtils.newInstance((String)transformer);
            return mt.transform(value);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Cannot create Matcher instance: " + t);
        }
    }

    public Matcher transform(Object value) {
        return new DefaultMatcher(value);
    }
}

