/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.kernel.plugins.annotations.BasicBeanAnnotationAdapter;
import org.jboss.kernel.plugins.annotations.BeanAnnotationAdapter;
import org.jboss.logging.Logger;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;

public class BeanAnnotationAdapterFactory {
    private static Logger log = Logger.getLogger(BeanAnnotationAdapterFactory.class);
    private static final BeanAnnotationAdapterFactory factory = new BeanAnnotationAdapterFactory();
    private String adapterClassName;
    private BeanAnnotationAdapter adapter;

    private BeanAnnotationAdapterFactory() {
    }

    public static BeanAnnotationAdapterFactory getInstance() {
        return factory;
    }

    public void setAdapterClassName(String adapterClassName) {
        this.adapterClassName = adapterClassName;
    }

    public BeanAnnotationAdapter getBeanAnnotationAdapter() {
        if (this.adapter == null) {
            this.adapter = AccessController.doPrivileged(new AdapterLookup());
        }
        return this.adapter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AdapterLookup
    implements PrivilegedAction<BeanAnnotationAdapter> {
        private AdapterLookup() {
        }

        @Override
        public BeanAnnotationAdapter run() {
            try {
                String adapterClass = System.getProperty("org.jboss.kernel.plugins.annotations.BeanAnnotationAdapter", BeanAnnotationAdapterFactory.this.adapterClassName);
                if (adapterClass != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Instantiating bean annotation adapter: " + adapterClass));
                    }
                    Object result = ReflectionUtils.newInstance((String)adapterClass);
                    return (BeanAnnotationAdapter)BeanAnnotationAdapter.class.cast(result);
                }
            }
            catch (Throwable t) {
                log.warn((Object)("Exception while creating bean annotation adapter instance: " + t));
            }
            return BasicBeanAnnotationAdapter.INSTANCE;
        }
    }
}

