/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.domain;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.classpool.domain.ClassPoolDomain;

public class ClassPoolDomainRegistry {
    static final ClassPoolDomainRegistry INSTANCE = new ClassPoolDomainRegistry();
    final Map<Object, WeakReference<ClassPoolDomain>> domains = new WeakHashMap<Object, WeakReference<ClassPoolDomain>>();
    ReadWriteLock lock = new ReentrantReadWriteLock();

    public static ClassPoolDomainRegistry getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPoolDomain getDomain(Object key) {
        this.lock.readLock().lock();
        try {
            WeakReference<ClassPoolDomain> ref = this.domains.get(key);
            if (ref == null) {
                ClassPoolDomain classPoolDomain = null;
                return classPoolDomain;
            }
            ClassPoolDomain classPoolDomain = (ClassPoolDomain)ref.get();
            return classPoolDomain;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassPoolDomain(Object key, ClassPoolDomain domain) {
        this.lock.writeLock().lock();
        try {
            this.domains.put(key, new WeakReference<ClassPoolDomain>(domain));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

