/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.resolver;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.resolver.MutableSchemaResolverWithQNameMapping;
import org.jboss.xb.binding.sunday.unmarshalling.LSInputAdaptor;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingInitializer;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
import org.jboss.xb.builder.JBossXBBuilder;
import org.jboss.xb.util.DefaultSchemaBindingValidator;
import org.jboss.xb.util.SchemaBindingValidator;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableSchemaResolver
implements MutableSchemaResolverWithQNameMapping {
    private Logger log;
    private String baseURI;
    private JBossEntityResolver resolver;
    private boolean cacheResolvedSchemas = true;
    private Map<String, SchemaBinding> schemasByUri = Collections.emptyMap();
    private Map<String, Boolean> schemaParseAnnotationsByUri = Collections.emptyMap();
    private Map<String, SchemaBindingInitializer> schemaInitByUri = Collections.emptyMap();
    private boolean validateBinding = false;
    private SchemaBindingValidator validator;

    protected AbstractMutableSchemaResolver(Logger log) {
        this(log, new JBossEntityResolver());
    }

    protected AbstractMutableSchemaResolver(Logger log, JBossEntityResolver resolver) {
        if (log == null) {
            throw new IllegalArgumentException("Logger is null!");
        }
        this.log = log;
        this.resolver = resolver;
    }

    public boolean isValidateBinding() {
        return this.validateBinding;
    }

    public void setValidateBinding(boolean validateBinding) {
        this.validateBinding = validateBinding;
    }

    public SchemaBindingValidator getBindingValidator() {
        return this.validator;
    }

    public void setBindingValidator(SchemaBindingValidator validator) {
        this.validator = validator;
    }

    @Override
    public boolean isCacheResolvedSchemas() {
        return this.cacheResolvedSchemas;
    }

    @Override
    public void setCacheResolvedSchemas(boolean cacheResolvedSchemas) {
        this.cacheResolvedSchemas = cacheResolvedSchemas;
        if (!cacheResolvedSchemas) {
            this.schemasByUri = Collections.emptyMap();
        }
    }

    @Override
    public void mapSchemaLocation(String nsUri, String location) {
        this.resolver.registerLocalEntity(nsUri, location);
    }

    @Override
    public void removeSchemaLocation(String nsUri) {
        this.resolver.registerLocalEntity(nsUri, null);
    }

    @Override
    public void setParseXSDAnnotations(String nsUri, boolean value) {
        if (nsUri == null) {
            throw new IllegalArgumentException("Null namespace uri");
        }
        switch (this.schemaParseAnnotationsByUri.size()) {
            case 0: {
                this.schemaParseAnnotationsByUri = Collections.singletonMap(nsUri, value);
                break;
            }
            case 1: {
                this.schemaParseAnnotationsByUri = new HashMap<String, Boolean>(this.schemaParseAnnotationsByUri);
            }
            default: {
                this.schemaParseAnnotationsByUri.put(nsUri, value);
            }
        }
    }

    @Override
    public Boolean unsetParseXSDAnnotations(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException("Null namespace uri");
        }
        return this.schemaParseAnnotationsByUri.remove(nsURI);
    }

    @Override
    public void mapSchemaInitializer(String nsUri, String sbiClassName) throws Exception {
        Class<?> clazz = this.loadReference(sbiClassName);
        Object object = clazz.newInstance();
        if (!(object instanceof SchemaBindingInitializer)) {
            throw new IllegalArgumentException(clazz.getName() + " is not an instance of " + SchemaBindingInitializer.class.getName());
        }
        SchemaBindingInitializer sbi = (SchemaBindingInitializer)object;
        this.mapSchemaInitializer(nsUri, sbi);
    }

    @Override
    public void mapSchemaInitializer(String nsUri, SchemaBindingInitializer sbi) {
        if (nsUri == null) {
            throw new IllegalArgumentException("Null namespace uri");
        }
        if (sbi == null) {
            throw new IllegalArgumentException("Null schema binding initializer");
        }
        switch (this.schemaInitByUri.size()) {
            case 0: {
                this.schemaInitByUri = Collections.singletonMap(nsUri, sbi);
                break;
            }
            case 1: {
                this.schemaInitByUri = new HashMap<String, SchemaBindingInitializer>(this.schemaInitByUri);
            }
            default: {
                this.schemaInitByUri.put(nsUri, sbi);
            }
        }
    }

    @Override
    public SchemaBindingInitializer removeSchemaInitializer(String nsUri) {
        if (nsUri == null) {
            throw new IllegalArgumentException("Null namespace uri");
        }
        return this.schemaInitByUri.remove(nsUri);
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public SchemaBinding resolve(String nsURI, String localName, String schemaLocation) {
        InputSource is;
        boolean trace = this.log.isTraceEnabled();
        boolean foundByNS = false;
        SchemaBinding schema = this.schemasByUri.get(nsURI);
        if (schema != null) {
            if (trace) {
                this.log.trace((Object)("resolved cached schema, nsURI=" + nsURI + ", schema: " + schema));
            }
            return schema;
        }
        Class<?>[] classes = null;
        if (localName != null) {
            classes = this.getClassesForQName(new QName(nsURI, localName));
        }
        if (classes == null) {
            classes = this.resolveClassFromSchemaLocation(schemaLocation, trace);
        }
        if (classes == null && (classes = this.getClassesForURI(nsURI)) != null) {
            foundByNS = true;
        }
        if (classes != null) {
            if (trace) {
                this.log.trace((Object)("found bindingClass, nsURI=" + nsURI + ", localName=" + localName + ", schemaLocation=" + schemaLocation + ", classes=" + Arrays.asList(classes)));
            }
            schema = JBossXBBuilder.build(classes);
        } else {
            is = this.getInputSource(nsURI, null, schemaLocation);
            if (trace) {
                String msg = (is == null ? "couldn't find" : "found") + " schema InputSource, nsURI=" + nsURI + ", localName=" + localName + ", schemaLocation=" + schemaLocation;
                this.log.trace((Object)msg);
            }
            if (is != null) {
                Boolean processAnnotationsBoolean = this.schemaParseAnnotationsByUri.get(nsURI);
                boolean processAnnotations = processAnnotationsBoolean == null || processAnnotationsBoolean != false;
                try {
                    schema = XsdBinder.bind(is.getByteStream(), null, this.baseURI, processAnnotations);
                    foundByNS = true;
                }
                catch (RuntimeException e) {
                    String msg = "Failed to parse schema for nsURI=" + nsURI + ", localName=" + localName + ", schemaLocation=" + schemaLocation;
                    throw new JBossXBRuntimeException(msg, e);
                }
            }
        }
        if (schema != null) {
            schema.setSchemaResolver(this);
            SchemaBindingInitializer sbi = this.schemaInitByUri.get(nsURI);
            if (sbi != null) {
                schema = sbi.init(schema);
            }
            if (schema != null && nsURI.length() > 0 && this.cacheResolvedSchemas && foundByNS) {
                if (this.schemasByUri.isEmpty()) {
                    this.schemasByUri = new HashMap<String, SchemaBinding>();
                }
                this.schemasByUri.put(nsURI, schema);
            }
        }
        if (trace) {
            this.log.trace((Object)("resolved schema: " + schema));
        }
        if (classes != null && this.validateBinding) {
            is = this.getInputSource(nsURI, null, schemaLocation);
            if (is != null) {
                SchemaBindingValidator validator = this.validator;
                if (validator == null) {
                    validator = new DefaultSchemaBindingValidator(this);
                }
                try {
                    validator.validate(is, schema);
                }
                catch (RuntimeException rt) {
                    this.schemasByUri.remove(nsURI);
                    throw rt;
                }
            } else {
                this.log.warn((Object)("schema binding validation is on but skipped since XSD nsURI=" + nsURI + ", schemaLocation=" + schemaLocation + " could not be found."));
            }
        }
        return schema;
    }

    @Override
    public void mapURIToClass(String nsUri, String reference) throws ClassNotFoundException {
        this.mapURIToClass(nsUri, this.loadReference(reference));
    }

    @Override
    public void mapURIToClasses(String nsUri, String ... reference) throws ClassNotFoundException {
        Class[] classes = new Class[reference.length];
        int i = 0;
        for (String ref : reference) {
            classes[i++] = this.loadReference(ref);
        }
        this.mapURIToClasses(nsUri, classes);
    }

    @Override
    public void mapLocationToClass(String schemaLocation, String reference) throws ClassNotFoundException {
        this.mapLocationToClass(schemaLocation, this.loadReference(reference));
    }

    @Override
    public void mapLocationToClasses(String schemaLocation, String ... reference) throws ClassNotFoundException {
        Class[] classes = new Class[reference.length];
        int i = 0;
        for (String ref : reference) {
            classes[i++] = this.loadReference(ref);
        }
        this.mapLocationToClasses(schemaLocation, classes);
    }

    protected Class<?> loadReference(String sbiClassName) throws ClassNotFoundException {
        if (sbiClassName == null) {
            throw new IllegalArgumentException("Null class name");
        }
        return Thread.currentThread().getContextClassLoader().loadClass(sbiClassName);
    }

    protected Class<?>[] resolveClassFromSchemaLocation(String schemaLocation, boolean trace) {
        Class<?>[] classes;
        block6: {
            classes = this.getClassesForSchemaLocation(schemaLocation);
            if (classes == null && schemaLocation != null && schemaLocation.length() > 0) {
                try {
                    int slash;
                    URI url = new URI(schemaLocation);
                    String path = url.getPath();
                    if (path == null) {
                        path = url.getSchemeSpecificPart();
                    }
                    String filename = (slash = path.lastIndexOf(47)) >= 0 ? path.substring(slash + 1) : path;
                    if (path.length() == 0) {
                        return null;
                    }
                    if (trace) {
                        this.log.trace((Object)("Mapped schemaLocation to filename: " + filename));
                    }
                    classes = this.getClassesForSchemaLocation(filename);
                }
                catch (URISyntaxException e) {
                    if (!trace) break block6;
                    this.log.trace((Object)"schemaLocation: is not a URI, using systemId as resource", (Throwable)e);
                }
            }
        }
        return classes;
    }

    @Override
    public LSInput resolveAsLSInput(String nsURI, String baseURI, String schemaLocation) {
        LSInputAdaptor lsInput = null;
        InputSource is = this.getInputSource(nsURI, baseURI, schemaLocation);
        if (is != null) {
            String publicId = is.getPublicId();
            String systemId = is.getSystemId();
            lsInput = new LSInputAdaptor(publicId, systemId, baseURI);
            lsInput.setCharacterStream(is.getCharacterStream());
            lsInput.setByteStream(is.getByteStream());
            lsInput.setEncoding(is.getEncoding());
        }
        return lsInput;
    }

    private InputSource getInputSource(String nsURI, String baseURI, String schemaLocation) {
        InputSource is;
        boolean trace;
        block17: {
            block16: {
                block15: {
                    trace = this.log.isTraceEnabled();
                    is = null;
                    if (trace) {
                        this.log.trace((Object)("getInputSource, nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation));
                    }
                    try {
                        is = this.resolver.resolveEntity(nsURI, schemaLocation);
                        if (trace) {
                            String msg = (is == null ? "Couldn't resolve" : "Resolved") + " schema using namespace as publicId and schemaLocation as systemId";
                            this.log.trace((Object)msg);
                        }
                    }
                    catch (Exception e) {
                        if (!trace) break block15;
                        this.log.trace((Object)"Failed to use nsUri/schemaLocation", (Throwable)e);
                    }
                }
                if (baseURI == null) {
                    baseURI = this.baseURI;
                }
                if (is == null && baseURI != null && schemaLocation != null) {
                    try {
                        URL url = new URL(baseURI);
                        url = new URL(url, schemaLocation);
                        String resolvedSchemaLocation = url.toString();
                        if (!schemaLocation.equals(resolvedSchemaLocation)) {
                            is = this.resolver.resolveEntity(null, url.toString());
                            if (trace && is != null) {
                                this.log.trace((Object)"Resolved schema location using baseURI");
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!trace) break block16;
                        this.log.trace((Object)"Failed to use schema location with baseURI", (Throwable)e);
                    }
                }
            }
            if (is == null && nsURI != null) {
                try {
                    is = this.resolver.resolveEntity(null, nsURI);
                    if (trace && is != null) {
                        this.log.trace((Object)"Resolved namespace as system id");
                    }
                }
                catch (Exception e) {
                    if (!trace) break block17;
                    this.log.trace((Object)"Failed to use namespace as system id", (Throwable)e);
                }
            }
        }
        if (trace) {
            this.log.trace((Object)("getInputSource, nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation + ", is=" + is));
        }
        return is;
    }

    protected abstract Class<?>[] getClassesForURI(String var1);

    protected abstract Class<?>[] getClassesForSchemaLocation(String var1);

    protected abstract Class<?>[] getClassesForQName(QName var1);
}

